package com.github.barnabeepickle.modmenu.gui;

import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;

public class DescriptionListWidget extends class_350<DescriptionListWidget.DescriptionEntry> {

	private final ModsScreen parent;
	private final class_327 textRenderer;
	private ModListEntry lastSelected = null;

	public DescriptionListWidget(class_310 client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
		super(client, width, height, top, bottom, entryHeight);
		this.parent = parent;
		this.textRenderer = client.field_1772;
	}

	@Override
	public DescriptionEntry getSelected() {
		return null;
	}

	@Override
	public int getRowWidth() {
		return this.width - 10;
	}

	@Override
	protected int getScrollbarPosition() {
		return this.width - 6 + field_19088;
	}

	@Override
	public void render(int mouseX, int mouseY, float delta) {
		ModListEntry selectedEntry = parent.getSelectedEntry();
		if (selectedEntry != lastSelected) {
			lastSelected = selectedEntry;
			clearEntries();
			setScrollAmount(-Double.MAX_VALUE);
			String description = lastSelected.getMetadata().getDescription();
			String id = lastSelected.getMetadata().getId();
			if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(id)) {
				description = HardcodedUtil.getHardcodedDescription(id);
			}
			if (lastSelected != null && description != null && !description.isEmpty()) {
				for (String line : textRenderer.method_1728(description.replaceAll("\n", "\n\n"), getRowWidth())) {
					children().add(new DescriptionEntry(line));
				}
			}
		}
		super.render(mouseX, mouseY, delta);
	}

	@Override
	protected void renderHoleBackground(int y1, int y2, int startAlpha, int endAlpha) {
		// Awful hack but it makes the background "seamless"
		ModsScreen.overlayBackground(field_19088, y1, field_19087, y2, 64, 64, 64, startAlpha, endAlpha);
	}

	protected class DescriptionEntry extends class_350.class_351<DescriptionEntry> {
		protected String text;

		public DescriptionEntry(String text) {
			this.text = text;
		}

		@Override
		public void render(int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
			class_310.method_1551().field_1772.method_1720(text, x, y, 0xAAAAAA);
		}
	}

}
