package com.github.barnabeepickle.modmenu.mixin;

import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.gui.ModMenuButtonWidget;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_433;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_433.class)
public class MixinGameMenuScreen extends class_437 {

	public MixinGameMenuScreen(class_2561 title) {
		super(title);
	}

	@Inject(at = @At("RETURN"), method = "initWidgets()V")
	public void drawMenuButton(CallbackInfo info) {
		addButton(new ModMenuButtonWidget(this.width / 2 - 102, this.height / 4 + 8 + 24 * 3, 204, 20, class_1074.method_4662("modmenu.title") + " " + class_1074.method_4662("modmenu.loaded", ModMenu.getDisplayedModCount()), this), 5);
	}

	private void addButton(class_339 button, int tabOrder) {
		addButton(button);
		//Bit of ugly code to set the tab order of a button after the fact, better than a fragile mixin
		children.remove(button);
		children.add(tabOrder, button);
	}

	protected <T extends class_339> T addButton(T button) {
		if (button.y >= this.height / 4 - 16 + 24 * 4 - 1 && !(button instanceof ModMenuButtonWidget)) {
			button.y += 24;
		}
		button.y -= 12;
		return super.addButton(button);
	}
}
