package com.github.barnabeepickle.modmenu.mixin;

import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.gui.ModMenuButtonWidget;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_442.class)
public class MixinTitleScreen extends class_437 {

	public MixinTitleScreen(class_2561 title) {
		super(title);
	}

	@Inject(at = @At("RETURN"), method = "initWidgetsNormal(II)V")
	public void drawMenuButton(CallbackInfo info) {
		this.addButton(new ModMenuButtonWidget(this.width / 2 - 100, this.height / 4 + 48 + 24 * 3, 200, 20, class_1074.method_4662("modmenu.title") + " " + class_1074.method_4662("modmenu.loaded", ModMenu.getDisplayedModCount()), this));
	}

	@ModifyArg(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;init(Lnet/minecraft/client/MinecraftClient;II)V"), method = "init", index = 2)
	private int adjustRealmsHeight(int height) {
		return height - 51;
	}

	protected <T extends class_339> T addButton(T button) {
		if (button.y <= this.height / 4 + 48 + 24 * 3) {
			button.y -= 12;
		}
		if (button.y > this.height / 4 + 48 + 24 * 3) {
			button.y += 12;
		}
		return super.addButton(button);
	}
}
