package com.github.barnabeepickle.modmenu.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.util.BadgeRenderer;
import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import com.github.barnabeepickle.modmenu.util.RenderUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

public class ModListEntry extends class_4280.class_4281<ModListEntry> {
	public static final class_2960 UNKNOWN_ICON = new class_2960("textures/misc/unknown_pack.png");
	private static final Logger LOGGER = LogManager.getLogger();

	protected final class_310 client;
	protected final ModContainer container;
	protected final ModMetadata metadata;
	protected final ModListWidget list;
	protected class_2960 iconLocation;

	public ModListEntry(ModContainer container, ModListWidget list) {
		this.container = container;
		this.list = list;
		this.metadata = container.getMetadata();
		this.client = class_310.method_1551();
	}

	@Override
	public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
		x += getXOffset();
		rowWidth -= getXOffset();
		GlStateManager.color4f(1.0F, 1.0F, 1.0F, 1.0F);
		this.bindIconTexture();
		GlStateManager.enableBlend();
		class_332.blit(x, y, 0.0F, 0.0F, 32, 32, 32, 32);
		GlStateManager.disableBlend();
		String name = HardcodedUtil.formatFabricModuleName(metadata.getName());
		String trimmedName = name;
		int maxNameWidth = rowWidth - 32 - 3;
		class_327 font = this.client.field_1772;
		if (font.method_1727(name) > maxNameWidth) {
			trimmedName = font.method_1714(name, maxNameWidth - font.method_1727("...")) + "...";
		}
		font.method_1729(trimmedName, x + 32 + 3, y + 1, 0xFFFFFF);
		new BadgeRenderer(x + 32 + 3 + font.method_1727(name) + 2, y, x + rowWidth, container, list.getParent()).draw(mouseX, mouseY);
		String description = metadata.getDescription();
		if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(metadata.getId())) {
			description = HardcodedUtil.getHardcodedDescription(metadata.getId());
		}
		RenderUtils.drawWrappedString(description, (x + 32 + 3 + 4), (y + client.field_1772.field_2000 + 2), rowWidth - 32 - 7, 2, 0x808080);
	}

	@SuppressWarnings("deprecation")
	private class_1043 createIcon() {
		try {
			Path path = container.getPath(metadata.getIconPath(64 * class_310.method_1551().field_1690.field_1868).orElse("assets/" + metadata.getId() + "/icon.png"));
			class_1043 cached = this.list.getCachedModIcon(path);
			if (cached != null) {
				return cached;
			}
			if (!Files.exists(path)) {
				ModContainer modMenu = FabricLoader.getInstance().getModContainer(ModMenu.MOD_ID).orElseThrow(IllegalAccessError::new);
				if (HardcodedUtil.getFabricMods().contains(metadata.getId())) {
					path = modMenu.getPath("assets/" + ModMenu.MOD_ID + "/fabric_icon.png");
				} else if (metadata.getId().equals("minecraft")) {
					path = modMenu.getPath("assets/" + ModMenu.MOD_ID + "/mc_icon.png");
				} else {
					path = modMenu.getPath("assets/" + ModMenu.MOD_ID + "/grey_fabric_icon.png");
				}
			}
			cached = this.list.getCachedModIcon(path);
			if (cached != null) {
				return cached;
			}
			try (InputStream inputStream = Files.newInputStream(path)) {
				class_1011 image = class_1011.method_4309(Objects.requireNonNull(inputStream));
				Validate.validState(image.method_4323() == image.method_4307(), "Must be square icon");
				class_1043 tex = new class_1043(image);
				this.list.cacheModIcon(path, tex);
				return tex;
			}

		} catch (Throwable t) {
			LOGGER.error("Invalid icon for mod {}", this.container.getMetadata().getName(), t);
			return null;
		}
	}

	@Override
	public boolean mouseClicked(double v, double v1, int i) {
		list.select(this);
		return true;
	}

	public ModMetadata getMetadata() {
		return metadata;
	}

	public void bindIconTexture() {
		if (this.iconLocation == null) {
			this.iconLocation = new class_2960("modmenu", metadata.getId() + "_icon");
			class_1043 icon = this.createIcon();
			if (icon != null) {
				this.client.method_1531().method_4616(this.iconLocation, icon);
			} else {
				this.iconLocation = UNKNOWN_ICON;
			}
		}
		this.client.method_1531().method_4618(this.iconLocation);
	}

	public int getXOffset() {
		return 0;
	}
}
