package com.github.barnabeepickle.modmenu.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;

public class ModMenuTexturedButtonWidget extends class_4185 {
	private final class_2960 texture;
	private final int u;
	private final int v;
	private final int uWidth;
	private final int vHeight;

	protected ModMenuTexturedButtonWidget(int x, int y, int width, int height, int u, int v, class_2960 texture, class_4241 onPress) {
		this(x, y, width, height, u, v, texture, 256, 256, onPress);
	}

	protected ModMenuTexturedButtonWidget(int x, int y, int width, int height, int u, int v, class_2960 texture, int uWidth, int vHeight, class_4241 onPress) {
		this(x, y, width, height, u, v, texture, uWidth, vHeight, onPress, "");
	}

	protected ModMenuTexturedButtonWidget(int x, int y, int width, int height, int u, int v, class_2960 texture, int uWidth, int vHeight, class_4241 onPress, String message) {
		super(x, y, width, height, message, onPress);
		this.uWidth = uWidth;
		this.vHeight = vHeight;
		this.u = u;
		this.v = v;
		this.texture = texture;
	}

	protected void setPos(int x, int y) {
		this.x = x;
		this.y = y;
	}

	@Override
	public void renderButton(int mouseX, int mouseY, float delta) {
		class_310 client = class_310.method_1551();
		client.method_1531().method_4618(this.texture);
		GlStateManager.color4f(1, 1, 1, 1f);
		GlStateManager.disableDepthTest();
		int adjustedV = this.v;
		if (!active) {
			adjustedV += this.height * 2;
		} else if (this.isHovered()) {
			adjustedV += this.height;
		}

		blit(this.x, this.y, this.u, adjustedV, this.width, this.height, this.uWidth, this.vHeight);
		GlStateManager.enableDepthTest();
	}
}
