/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.potionsandsuch.entities;

import magnusmakesgames.potionsandsuch.entities.ModEntities;
import magnusmakesgames.potionsandsuch.items.ModItems;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import net.minecraft.class_9381;

public class ExplosiveArrowEntity
extends class_1665 {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(ExplosiveArrowEntity.class, (class_2941)class_2943.field_13327);
    private static final byte PARTICLE_STATUS = 0;
    private static final double EXPLOSION_RADIUS = 2.5;

    public ExplosiveArrowEntity(class_1299<? extends ExplosiveArrowEntity> type, class_1937 world) {
        super(type, world);
    }

    public ExplosiveArrowEntity(class_1937 world, class_1309 owner, class_1799 potionStack, class_1799 arrowStack) {
        super(ModEntities.EXPLOSIVE_ARROW_ENTITY, owner, world, arrowStack, null);
        class_1844 comp = (class_1844)potionStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
        if (!comp.equals((Object)class_1844.field_49274)) {
            this.method_54759().method_57379(class_9334.field_49651, (Object)comp);
        }
        this.initColor();
    }

    private class_1844 getPotionContents() {
        return (class_1844)this.method_54759().method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
    }

    private void setPotionContents(class_1844 component) {
        this.method_54759().method_57379(class_9334.field_49651, (Object)component);
        this.initColor();
    }

    protected void method_57313(class_1799 stack) {
        super.method_57313(stack);
        this.initColor();
    }

    private void initColor() {
        class_1844 comp = this.getPotionContents();
        int color = comp.equals((Object)class_1844.field_49274) ? -1 : comp.method_8064();
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public void addEffect(class_1293 effect) {
        this.setPotionContents(this.getPotionContents().method_57398(effect));
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)-1);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            int color = this.getColor();
            if (color != -1 && !this.field_7588) {
                this.spawnParticles(2);
            }
            if (!this.field_7588) {
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnParticles(int amount) {
        int color = this.getColor();
        if (color == -1) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            this.method_37908().method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)color), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        if (!this.method_37908().field_9236) {
            this.Explode(hitResult.method_17784());
            if (!this.getPotionContents().equals((Object)class_1844.field_49274)) {
                this.spawnEffectExplosion(hitResult.method_17784(), this.method_37908());
                this.method_37908().method_8421((class_1297)this, (byte)0);
            }
            this.method_31472();
        }
    }

    public void method_5711(byte status) {
        if (status == 0) {
            this.spawnEffectExplosionParticles(this.method_19538(), this.method_37908());
        } else {
            super.method_5711(status);
        }
    }

    private void Explode(class_243 pos) {
        class_1937 world = this.method_37908();
        world.method_8396(null, class_2338.method_49638((class_2374)pos), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15248, 0.75f, 1.5f);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, pos.field_1352, pos.field_1351, pos.field_1350, 3, 0.5, 0.5, 0.5, 0.0);
        world.method_8390(class_1309.class, new class_238(pos.field_1352 - 2.5, pos.field_1351 - 2.5, pos.field_1350 - 2.5, pos.field_1352 + 2.5, pos.field_1351 + 2.5, pos.field_1350 + 2.5), class_1309::method_5805).forEach(entity -> {
            double distance = pos.method_1022(entity.method_19538());
            double damage = Math.max(0.0, 10.0 - distance * 2.0);
            entity.method_5643(world.method_48963().method_48819((class_1297)this, this.method_24921()), (float)damage);
            double dx = entity.method_23317() - pos.method_10216();
            double dy = entity.method_23318() - pos.method_10214();
            double dz = entity.method_23321() - pos.method_10215();
            double mag = Math.sqrt(dx * dx + dy * dy + dz * dz) + 0.1;
            entity.method_5762(dx / mag * 0.6, dy / mag * 0.6, dz / mag * 0.6);
            if (entity instanceof class_1657) {
                class_1657 p = (class_1657)entity;
                p.field_6037 = true;
            }
        });
        this.spawnFallingDebris(world, pos, 16);
    }

    private void spawnFallingDebris(class_1937 world, class_243 pos, int count) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < count; ++i) {
            int oz;
            int oy;
            class_2338 bp = class_2338.method_49638((class_2374)pos);
            int ox = bp.method_10263() + random.method_39332(-2, 2);
            class_2680 state = world.method_8320(bp = new class_2338(ox, oy = bp.method_10264() + random.method_39332(-1, 1), oz = bp.method_10260() + random.method_39332(-2, 2)));
            if (state.method_26215() || state.method_26204().method_9520() > 8.0f || !state.method_26227().method_15769() || state.method_31709() || world.method_8321(bp) != null) continue;
            world.method_22352(bp, false);
            class_1540 falling = class_1540.method_40005((class_1937)world, (class_2338)bp, (class_2680)state);
            falling.method_18800(0.0, 0.25 + random.method_43058() * 0.125, 0.0);
            falling.field_6007 = true;
            falling.field_6037 = true;
        }
    }

    private void spawnEffectExplosionParticles(class_243 pos, class_1937 world) {
        int color = this.getColor();
        for (int i = 0; i < 75; ++i) {
            class_243 offset = new class_243(this.field_5974.method_43058() - 0.5, this.field_5974.method_43058() - 0.5, this.field_5974.method_43058() - 0.5).method_1021(1.25);
            world.method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)color), pos.field_1352 + offset.field_1352, pos.field_1351 + offset.field_1351, pos.field_1350 + offset.field_1350, 0.0, 0.0, 0.0);
        }
    }

    private void spawnEffectExplosion(class_243 pos, class_1937 world1) {
        if (!(world1 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)world1;
        class_1844 comp = this.getPotionContents();
        Iterable effects = comp.method_57397();
        if (!effects.iterator().hasNext()) {
            return;
        }
        world.method_8390(class_1309.class, new class_238(pos.field_1352 - 2.5, pos.field_1351 - 2.5, pos.field_1350 - 2.5, pos.field_1352 + 2.5, pos.field_1351 + 2.5, pos.field_1350 + 2.5), class_1309::method_5805).forEach(entity -> {
            double distance = pos.method_1022(entity.method_19538());
            for (class_1293 eff : effects) {
                float duration = (float)eff.method_5584() * 0.25f;
                duration -= duration * (float)(distance / 2.5) * 0.5f;
                entity.method_6092(new class_1293(eff.method_5579(), (int)duration, eff.method_5578(), eff.method_5591(), eff.method_5581(), eff.method_5592()));
            }
        });
    }

    protected class_1799 method_57314() {
        return ModItems.EXPLOSIVE_ARROW.method_7854();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.initColor();
    }
}

