/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.potionsandsuch.entities;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import magnusmakesgames.potionsandsuch.entities.ModEntities;
import magnusmakesgames.potionsandsuch.helpers.PotionUtil;
import magnusmakesgames.potionsandsuch.items.ModItems;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_7923;
import net.minecraft.class_9381;

public class TippedSpectralArrowEntity
extends class_1665 {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(TippedSpectralArrowEntity.class, (class_2941)class_2943.field_13327);
    private static final byte PARTICLE_STATUS = 0;
    private class_1842 potion = null;
    private final Set<class_1293> customEffects = Sets.newHashSet();
    private boolean colorSet;

    public TippedSpectralArrowEntity(class_1299<TippedSpectralArrowEntity> tippedSpectralArrowEntityEntityType, class_1937 world) {
        super(ModEntities.TIPPED_SPECTRAL_ARROW_ENTITY, world);
    }

    public TippedSpectralArrowEntity(class_1937 world, class_1309 owner, class_1799 potionStack, class_1799 arrowStack) {
        super(ModEntities.TIPPED_SPECTRAL_ARROW_ENTITY, owner, world, arrowStack, null);
        this.initFromStack(potionStack);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)-1);
    }

    public void initFromStack(class_1799 stack) {
        this.potion = PotionUtil.getPotion(stack);
        List<class_1293> effects = PotionUtil.getCustomPotionEffects(stack);
        this.customEffects.addAll(effects);
        int color = PotionUtil.getColor(PotionUtil.getPotionEffects(this.potion, this.customEffects));
        this.setColor(color);
    }

    private void setColor(int color) {
        this.colorSet = true;
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            int color = this.getColor();
            if (color != -1) {
                double r = (double)(color >> 16 & 0xFF) / 255.0;
                double g = (double)(color >> 8 & 0xFF) / 255.0;
                double b = (double)(color & 0xFF) / 255.0;
                if (this.field_7588) {
                    if (this.field_7576 % 5 == 0) {
                        this.spawnParticles(1);
                    }
                } else {
                    this.spawnParticles(2);
                }
            }
            if (!this.field_7588) {
                this.method_37908().method_8406((class_2394)class_2398.field_11213, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnParticles(int amount) {
        int color = this.getColor();
        if (color == -1) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            this.method_37908().method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)color), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void method_7450(class_1309 target) {
        int duration;
        super.method_7450(target);
        class_1293 statusEffectInstance = new class_1293(class_1294.field_5912, 200, 0);
        target.method_37222(statusEffectInstance, this.method_37225());
        for (class_1293 effect : this.potion.method_8049()) {
            duration = Math.round((float)effect.method_5584() * 0.125f);
            target.method_6092(new class_1293(effect.method_5579(), duration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
        }
        for (class_1293 effect : this.customEffects) {
            duration = Math.round((float)effect.method_5584() * 0.125f);
            target.method_6092(new class_1293(effect.method_5579(), duration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
        }
    }

    protected class_1799 method_7445() {
        class_1799 stack = new class_1799((class_1935)ModItems.TIPPED_SPECTRAL_ARROW);
        if (this.potion != null) {
            PotionUtil.setPotion(stack, this.potion);
        }
        if (!this.customEffects.isEmpty()) {
            PotionUtil.setCustomPotionEffects(stack, this.customEffects);
        }
        return stack;
    }

    protected class_1799 method_57314() {
        return null;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.potion != null) {
            nbt.method_10582("Potion", class_7923.field_41179.method_10221((Object)this.potion).toString());
        }
        if (this.colorSet) {
            nbt.method_10569("Color", this.getColor());
        }
        if (!this.customEffects.isEmpty()) {
            class_2499 nbtList = new class_2499();
            for (class_1293 statusEffectInstance : this.customEffects) {
                nbtList.add((Object)statusEffectInstance.method_5582());
            }
            nbt.method_10566("CustomPotionEffects", (class_2520)nbtList);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Potion", 8)) {
            this.potion = PotionUtil.getPotion(nbt);
        }
        for (class_1293 statusEffectInstance : PotionUtil.getCustomPotionEffects(nbt)) {
            this.addEffect(statusEffectInstance);
        }
        if (nbt.method_10573("Color", 99)) {
            this.setColor(nbt.method_10550("Color"));
        } else {
            this.initColor();
        }
    }

    public void addEffect(class_1293 effect) {
        this.customEffects.add(effect);
        this.method_5841().method_12778(COLOR, (Object)PotionUtil.getColor(PotionUtil.getPotionEffects(this.potion, this.customEffects)));
    }

    private void initColor() {
        this.colorSet = false;
        if (this.potion == null && this.customEffects.isEmpty()) {
            this.field_6011.method_12778(COLOR, (Object)-1);
        } else {
            this.field_6011.method_12778(COLOR, (Object)PotionUtil.getColor(PotionUtil.getPotionEffects(this.potion, this.customEffects)));
        }
    }
}

