/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.potionsandsuch.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import magnusmakesgames.potionsandsuch.PotionsAndSuch;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PotionUtil {
    private static final int DEFAULT_COLOR = 0xF800F8;

    public static List<class_1293> getPotionEffects(class_1842 potion, Collection<class_1293> custom) {
        ArrayList list = Lists.newArrayList();
        if (potion != null) {
            list.addAll(potion.method_8049());
        }
        if (custom != null) {
            list.addAll(custom);
        }
        return list;
    }

    public static List<class_1293> getCustomPotionEffects(class_1799 stack) {
        class_1844 potionContents = (class_1844)stack.method_57824(class_9334.field_49651);
        if (potionContents == null) {
            return Lists.newArrayList();
        }
        List custom = potionContents.comp_2380();
        return custom == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)custom);
    }

    public static List<class_1293> getCustomPotionEffects(@Nullable class_2487 nbt) {
        if (nbt != null && nbt.method_10573("CustomPotionEffects", 9)) {
            class_2499 nbtList = nbt.method_10554("CustomPotionEffects", 10);
            ArrayList<class_1293> list = new ArrayList<class_1293>();
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                class_1293 statusEffectInstance = class_1293.method_5583((class_2487)nbtCompound);
                if (statusEffectInstance == null) continue;
                list.add(statusEffectInstance);
            }
            return list;
        }
        return new ArrayList<class_1293>();
    }

    public static int getColor(@Nullable class_1842 potion) {
        return potion == null ? 0xF800F8 : PotionUtil.getColor(potion.method_8049());
    }

    public static int getColor(@Nullable Collection<class_1293> effects) {
        if (effects == null || effects.isEmpty()) {
            return 0xF800F8;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int totalWeight = 0;
        for (class_1293 inst : effects) {
            if (!inst.method_5581()) continue;
            class_1291 effect = (class_1291)inst.method_5579().comp_349();
            int color = effect.method_5556();
            int weight = inst.method_5578() + 1;
            r += (float)weight * (float)(color >> 16 & 0xFF) / 255.0f;
            g += (float)weight * (float)(color >> 8 & 0xFF) / 255.0f;
            b += (float)weight * (float)(color >> 0 & 0xFF) / 255.0f;
            totalWeight += weight;
        }
        if (totalWeight == 0) {
            return 0;
        }
        r = r / (float)totalWeight * 255.0f;
        g = g / (float)totalWeight * 255.0f;
        b = b / (float)totalWeight * 255.0f;
        return (int)r << 16 | (int)g << 8 | (int)b;
    }

    @Nullable
    public static class_1842 getPotion(class_1799 stack) {
        class_1844 potionContents = (class_1844)stack.method_57824(class_9334.field_49651);
        if (potionContents == null) {
            return PotionsAndSuch.EMPTY_POTION;
        }
        Optional opt = potionContents.comp_2378();
        return opt.map(class_6880::comp_349).orElse(PotionsAndSuch.EMPTY_POTION);
    }

    @Nullable
    public static class_1842 getPotion(class_2487 nbt) {
        return nbt == null ? PotionsAndSuch.EMPTY_POTION : PotionUtil.byId(nbt.method_10558("Potion"));
    }

    public static class_1842 byId(String id) {
        if (id == null) {
            return PotionsAndSuch.EMPTY_POTION;
        }
        class_2960 identifier = class_2960.method_12829((String)id);
        if (identifier == null) {
            return PotionsAndSuch.EMPTY_POTION;
        }
        return (class_1842)class_7923.field_41179.method_10223(identifier);
    }

    public static class_1799 setPotion(class_1799 stack, class_1842 potion) {
        class_1844 current = (class_1844)stack.method_57824(class_9334.field_49651);
        class_1844 base = current == null ? class_1844.field_49274 : current;
        class_6880 entry = class_7923.field_41179.method_47983((Object)potion);
        if (entry == null) {
            return stack;
        }
        class_1844 updated = base.method_57403(entry);
        stack.method_57379(class_9334.field_49651, (Object)updated);
        return stack;
    }

    public static class_1799 setCustomPotionEffects(class_1799 stack, Collection<class_1293> effects) {
        if (effects == null || effects.isEmpty()) {
            return stack;
        }
        class_1844 current = (class_1844)stack.method_57824(class_9334.field_49651);
        if (current == null) {
            current = class_1844.field_49274;
        }
        class_1844 updated = current;
        for (class_1293 effect : effects) {
            Optional keyOptional = effect.method_5579().method_40230();
            if (keyOptional.isEmpty()) {
                PotionsAndSuch.LOGGER.warn("Skipping status effect with no key: " + String.valueOf(effect.method_5579()));
                continue;
            }
            class_6880 holder = class_7923.field_41174.method_40264((class_5321)keyOptional.get()).orElse(null);
            if (holder == null) {
                PotionsAndSuch.LOGGER.warn("Skipping unregistered status effect: " + String.valueOf(effect.method_5579()));
                continue;
            }
            class_1293 safeInstance = new class_1293(holder, effect.method_5584(), effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592());
            updated = updated.method_57398(safeInstance);
        }
        stack.method_57379(class_9334.field_49651, (Object)updated);
        return stack;
    }
}

