/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.potionsandsuch.entities;

import magnusmakesgames.potionsandsuch.ModSounds;
import magnusmakesgames.potionsandsuch.helpers.PotionHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1686;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8111;

public class AlchemistEntity
extends class_1588 {
    private static final float beneficialChance = 0.1f;
    private static final float neutralChance = 0.2f;
    private static final int maxPotionDuration = 10;
    private static final int rangeSquared = 144;
    private int potionCooldown = 0;
    private boolean isFleeing = false;
    private int fleeTicks = 0;
    private class_1799 nextPotion = null;
    public static final class_2940<Boolean> ATTACK_STATE = class_2945.method_12791(AlchemistEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_WALKING = class_2945.method_12791(AlchemistEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 walkAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public static int attackAnimationTimeout = 50;
    public int attackAnimationTimer = 0;
    private int walkingTicks = 0;

    public AlchemistEntity(class_1299<AlchemistEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createDefaultAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 40.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1338((class_1314)this, class_1657.class, 6.0f, 1.2, 1.4, living -> this.isFleeing));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_5773() {
        double distanceSq;
        class_1309 target;
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            this.setupAnimationStates();
        }
        if (world.method_8608()) {
            return;
        }
        this.field_6011.method_12778(IS_WALKING, (Object)(this.method_18798().method_1027() > 0.1 && !this.method_6510() ? 1 : 0));
        if (this.potionCooldown > 0) {
            --this.potionCooldown;
        }
        if ((target = this.method_5968()) != null && this.method_6057((class_1297)target) && !this.isFleeing && (distanceSq = this.method_5858((class_1297)target)) <= 144.0 && this.potionCooldown <= 0 && !this.method_6510()) {
            this.startAttacking();
            this.attackAnimationTimer = attackAnimationTimeout;
        }
        if (this.method_6510()) {
            --this.attackAnimationTimer;
            if (target != null) {
                this.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
                this.method_36456((float)(Math.toDegrees(Math.atan2(target.method_23321() - this.method_23321(), target.method_23317() - this.method_23317())) - 90.0));
                this.field_6283 = this.method_36454();
                this.field_6241 = this.method_36454();
            }
            if (this.attackAnimationTimer == attackAnimationTimeout / 2 && target != null) {
                this.attemptThrowPotion(target);
            }
            if (this.attackAnimationTimer <= 0) {
                this.stopAttacking();
            }
        }
        if (this.isFleeing) {
            --this.fleeTicks;
            if (this.fleeTicks <= 0) {
                this.isFleeing = false;
            }
        }
    }

    private void attemptThrowPotion(class_1309 target) {
        this.method_6122(class_1268.field_5808, class_1799.field_8037);
        if (this.potionCooldown > 0) {
            return;
        }
        class_1937 world = this.method_37908();
        class_1686 potionEntity = new class_1686(world, (class_1309)this);
        class_1799 potion = this.nextPotion != null ? this.nextPotion : PotionHelper.getAlchemistAttackPotion(this.field_5974, 0.1f, 0.2f, 10);
        potionEntity.method_16940(potion);
        double dx = target.method_23317() - this.method_23317();
        double dy = target.method_23323(0.333) - potionEntity.method_23318();
        double dz = target.method_23321() - this.method_23321();
        double dist = Math.sqrt(dx * dx + dz * dz);
        potionEntity.method_7485(dx, dy + dist * 0.15, dz, 0.75f, 8.0f);
        world.method_8649((class_1297)potionEntity);
        world.method_43129(null, (class_1297)this, class_3417.field_14767, class_3419.field_15251, 1.0f, 1.0f);
        this.potionCooldown = 80 + this.field_5974.method_43048(20);
    }

    public boolean method_5679(class_1282 source) {
        if (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329)) {
            return true;
        }
        return super.method_5679(source);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        class_1937 world = this.method_37908();
        if (!world.field_9236 && source.method_5529() instanceof class_1657) {
            this.startFleeing();
        }
        return result;
    }

    private void startFleeing() {
        this.isFleeing = true;
        this.fleeTicks = 30 + this.field_5974.method_43048(20);
        this.method_5942().method_6340();
        class_243 randomDir = new class_243(this.field_5974.method_43058() - 0.5, 0.0, this.field_5974.method_43058() - 0.5).method_1029().method_1021(8.0);
        this.method_5942().method_6337(this.method_23317() + randomDir.field_1352, this.method_23318(), this.method_23321() + randomDir.field_1350, 1.2);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACK_STATE, (Object)false);
        this.field_6011.method_12784(IS_WALKING, (Object)false);
    }

    public void stopAttacking() {
        this.field_6011.method_12778(ATTACK_STATE, (Object)false);
    }

    public void startAttacking() {
        this.field_6011.method_12778(ATTACK_STATE, (Object)true);
        this.nextPotion = PotionHelper.getAlchemistAttackPotion(this.field_5974, 0.1f, 0.2f, 10);
        this.method_6122(class_1268.field_5808, this.nextPotion);
    }

    public boolean method_6510() {
        return (Boolean)this.field_6011.method_12789(ATTACK_STATE);
    }

    private void setupAnimationStates() {
        boolean isWalking;
        double diffX = this.field_6014 - this.method_23317();
        double diffZ = this.field_5969 - this.method_23321();
        double distanceSq = diffX * diffX + diffZ * diffZ;
        --this.walkingTicks;
        boolean bl = isWalking = distanceSq > 2.0E-4 && !this.method_6510();
        if (isWalking) {
            this.walkingTicks = 3;
        }
        boolean bl2 = isWalking = isWalking || this.walkingTicks > 0;
        if (this.attackAnimationTimer <= 0 && !isWalking) {
            if (!this.idleAnimationState.method_41327()) {
                this.idleAnimationState.method_41322(this.field_6012);
            }
        } else if (this.idleAnimationState.method_41327()) {
            this.idleAnimationState.method_41325();
        }
        if (isWalking) {
            if (!this.walkAnimationState.method_41327()) {
                this.walkAnimationState.method_41322(this.field_6012);
            }
        } else if (this.walkAnimationState.method_41327()) {
            this.walkAnimationState.method_41325();
        }
        --this.attackAnimationTimer;
        if (this.method_6510()) {
            if (this.attackAnimationTimer <= 0) {
                this.attackAnimationTimer = attackAnimationTimeout + 1;
            }
            if (this.attackAnimationTimer == attackAnimationTimeout) {
                this.idleAnimationState.method_41325();
                if (!this.attackAnimationState.method_41327()) {
                    this.attackAnimationState.method_41322(this.field_6012);
                }
            }
        } else if (this.attackAnimationState.method_41327()) {
            this.attackAnimationState.method_41325();
        }
    }

    public float method_6029() {
        float fleeMultiplier = 1.5f;
        float attackingMultiplier = 0.25f;
        float defaultSpeed = super.method_6029();
        if (this.method_6510()) {
            return defaultSpeed * attackingMultiplier;
        }
        if (this.isFleeing) {
            return defaultSpeed * fleeMultiplier;
        }
        return defaultSpeed;
    }

    public static boolean canSpawn(class_1299<AlchemistEntity> type, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean isDarkEnough;
        class_3218 world = serverWorldAccess.method_8410();
        if (world == null) {
            return false;
        }
        boolean isCave = pos.method_10264() < 40;
        boolean isFullMoon = world.method_30273() == 0;
        boolean isNight = world.method_23886();
        boolean bl = isDarkEnough = world.method_8314(class_1944.field_9282, pos) < 2;
        if (!isCave && isFullMoon && isNight && isDarkEnough) {
            return true;
        }
        if (isCave && isDarkEnough) {
            return random.method_43048(9) == 0;
        }
        return false;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.ALCHEMIST_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.ALCHEMIST_DEATH;
    }

    public boolean method_5961() {
        return false;
    }
}

