/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.potionsandsuch.entities;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import magnusmakesgames.potionsandsuch.PotionsAndSuch;
import magnusmakesgames.potionsandsuch.entities.ModEntities;
import magnusmakesgames.potionsandsuch.items.ModItems;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class ExplosiveArrowEntity
extends class_1665 {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(ExplosiveArrowEntity.class, (class_2941)class_2943.field_13327);
    private static final byte PARTICLE_STATUS = 0;
    private static final double EXPLOSION_RADIUS = 2.5;
    private class_1842 potion = class_1847.field_8984;
    private final Set<class_1293> customEffects = Sets.newHashSet();
    private boolean colorSet;

    public ExplosiveArrowEntity(class_1299<ExplosiveArrowEntity> ___, class_1937 world) {
        super(ModEntities.EXPLOSIVE_ARROW_ENTITY, world);
    }

    public ExplosiveArrowEntity(class_1937 world, class_1309 owner, class_1799 potionStack) {
        super(ModEntities.EXPLOSIVE_ARROW_ENTITY, owner, world);
        this.initFromStack(potionStack);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)-1);
    }

    public void initFromStack(class_1799 stack) {
        this.potion = class_1844.method_8063((class_1799)stack);
        List effects = class_1844.method_8068((class_1799)stack);
        if (this.potion.method_8049().isEmpty() && effects.isEmpty()) {
            return;
        }
        this.customEffects.addAll(effects);
        int color = class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.customEffects));
        this.setColor(color);
    }

    private class_243 getColorVector() {
        int color = this.getColor();
        double r = (double)(color >> 16 & 0xFF) / 255.0;
        double g = (double)(color >> 8 & 0xFF) / 255.0;
        double b = (double)(color & 0xFF) / 255.0;
        return new class_243(r, g, b);
    }

    private void setColor(int color) {
        this.colorSet = true;
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            int color = this.getColor();
            if (color != -1) {
                class_243 colorVec = this.getColorVector();
                if (this.field_7588) {
                    if (this.field_7576 % 5 == 0) {
                        this.spawnParticles(colorVec.field_1352, colorVec.field_1351, colorVec.field_1350, 1);
                    }
                } else {
                    this.spawnParticles(colorVec.field_1352, colorVec.field_1351, colorVec.field_1350, 2);
                }
            }
            if (!this.field_7588) {
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnParticles(double r, double g, double b, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), r, g, b);
        }
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        if (!this.method_37908().field_9236) {
            this.Explode(hitResult.method_17784());
            if (class_1844.method_8063((class_1799)this.method_7445()) != null && !class_1844.method_8067((class_1799)this.method_7445()).isEmpty()) {
                this.spawnEffectExplosion(hitResult.method_17784(), this.method_37908());
                this.method_37908().method_8421((class_1297)this, (byte)0);
            }
            this.method_31472();
        }
    }

    public void method_5711(byte status) {
        if (status == 0) {
            this.spawnEffectExplosionParticles(this.method_19538(), this.method_37908());
        } else {
            super.method_5711(status);
        }
    }

    private void Explode(class_243 pos) {
        class_1937 world = this.method_37908();
        world.method_8396(null, class_2338.method_49638((class_2374)pos), class_3417.field_15152, class_3419.field_15248, 0.75f, 1.5f);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, pos.method_10216(), pos.method_10214(), pos.method_10215(), 3, 0.5, 0.5, 0.5, 0.0);
        world.method_8390(class_1309.class, new class_238(pos.field_1352 - 2.5, pos.field_1351 - 2.5, pos.field_1350 - 2.5, pos.field_1352 + 2.5, pos.field_1351 + 2.5, pos.field_1350 + 2.5), class_1309::method_5805).forEach(entity -> {
            double distance = pos.method_1022(entity.method_19538());
            double damage = Math.max(0.0, 10.0 - distance * 2.0);
            entity.method_5643(world.method_48963().method_48819((class_1297)this, this.method_24921()), (float)damage);
            double dx = entity.method_23317() - pos.method_10216();
            double dy = entity.method_23318() - pos.method_10214();
            double dz = entity.method_23321() - pos.method_10215();
            double mag = Math.sqrt(dx * dx + dy * dy + dz * dz) + 0.1;
            entity.method_5762(dx / mag * 0.6, dy / mag * 0.6, dz / mag * 0.6);
            if (entity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)entity;
                playerEntity.field_6037 = true;
            }
        });
        this.spawnFallingDebris(world, pos, 16);
    }

    private void spawnFallingDebris(class_1937 world, class_243 pos, int count) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < count; ++i) {
            int oz;
            int oy;
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            int ox = blockPos.method_10263() + random.method_39332(-2, 2);
            class_2680 state = world.method_8320(blockPos = new class_2338(ox, oy = blockPos.method_10264() + random.method_39332(-1, 1), oz = blockPos.method_10260() + random.method_39332(-2, 2)));
            if (state.method_26215() || state.method_26204().method_9520() > 8.0f || !state.method_26204().method_9564().method_26227().method_15769() || state.method_31709() || world.method_8321(blockPos) != null) continue;
            world.method_22352(blockPos, false);
            class_1540 falling = class_1540.method_40005((class_1937)world, (class_2338)blockPos, (class_2680)state);
            falling.method_18800(0.0, 0.25 + random.method_43058() * 0.125, 0.0);
            falling.field_6007 = true;
            falling.field_6037 = true;
        }
    }

    private void spawnEffectExplosionParticles(class_243 pos, class_1937 world) {
        PotionsAndSuch.LOGGER.info("spawning particles");
        class_243 colorVec = this.getColorVector();
        for (int i = 0; i < 75; ++i) {
            class_243 offset = new class_243(this.field_5974.method_43058() - 0.5, this.field_5974.method_43058() - 0.5, this.field_5974.method_43058() - 0.5).method_1021(1.25);
            world.method_8406((class_2394)class_2398.field_11226, pos.field_1352 + offset.field_1352, pos.field_1351 + offset.field_1350, pos.field_1350 + offset.field_1351, colorVec.field_1352, colorVec.field_1351, colorVec.field_1350);
        }
    }

    private void spawnEffectExplosion(class_243 pos, class_1937 world1) {
        if (!(world1 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)world1;
        List effects = class_1844.method_8067((class_1799)this.method_7445());
        if (effects.isEmpty()) {
            return;
        }
        world.method_8390(class_1309.class, new class_238(pos.field_1352 - 2.5, pos.field_1351 - 2.5, pos.field_1350 - 2.5, pos.field_1352 + 2.5, pos.field_1351 + 2.5, pos.field_1350 + 2.5), class_1309::method_5805).forEach(entity -> {
            double distance = pos.method_1022(entity.method_19538());
            effects.forEach(effect -> {
                float duration = (float)effect.method_5584() * 0.25f;
                duration -= (float)((double)duration * (distance / 2.5) * 0.5);
                class_1293 newEffect = new class_1293(effect.method_5579(), (int)duration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592());
                entity.method_6092(newEffect);
            });
            double damage = Math.max(0.0, 10.0 - distance * 2.0);
            entity.method_5643(world.method_48963().method_48819((class_1297)this, this.method_24921()), (float)damage);
            double dx = entity.method_23317() - pos.method_10216();
            double dy = entity.method_23318() - pos.method_10214();
            double dz = entity.method_23321() - pos.method_10215();
            double mag = Math.sqrt(dx * dx + dy * dy + dz * dz) + 0.1;
            entity.method_5762(dx / mag * 0.6, dy / mag * 0.6, dz / mag * 0.6);
            if (entity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)entity;
                playerEntity.field_6037 = true;
            }
        });
    }

    protected class_1799 method_7445() {
        if (this.potion == class_1847.field_8984 && this.customEffects.isEmpty()) {
            return new class_1799((class_1935)ModItems.EXPLOSIVE_ARROW);
        }
        class_1799 stack = new class_1799((class_1935)ModItems.TIPPED_EXPLOSIVE_ARROW);
        if (this.potion != class_1847.field_8984) {
            class_1844.method_8061((class_1799)stack, (class_1842)this.potion);
        }
        if (!this.customEffects.isEmpty()) {
            class_1844.method_8056((class_1799)stack, this.customEffects);
        }
        return stack;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.potion != class_1847.field_8984) {
            nbt.method_10582("Potion", class_7923.field_41179.method_10221((Object)this.potion).toString());
        }
        if (this.colorSet) {
            nbt.method_10569("Color", this.getColor());
        }
        if (!this.customEffects.isEmpty()) {
            class_2499 nbtList = new class_2499();
            for (class_1293 statusEffectInstance : this.customEffects) {
                nbtList.add((Object)statusEffectInstance.method_5582(new class_2487()));
            }
            nbt.method_10566("CustomPotionEffects", (class_2520)nbtList);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Potion", 8)) {
            this.potion = class_1844.method_8057((class_2487)nbt);
        }
        for (class_1293 statusEffectInstance : class_1844.method_8060((class_2487)nbt)) {
            this.addEffect(statusEffectInstance);
        }
        if (nbt.method_10573("Color", 99)) {
            this.setColor(nbt.method_10550("Color"));
        } else {
            this.initColor();
        }
    }

    public void addEffect(class_1293 effect) {
        this.customEffects.add(effect);
        this.method_5841().method_12778(COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.customEffects)));
    }

    private void initColor() {
        this.colorSet = false;
        if (this.potion == class_1847.field_8984 && this.customEffects.isEmpty()) {
            this.field_6011.method_12778(COLOR, (Object)-1);
        } else {
            this.field_6011.method_12778(COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.customEffects)));
        }
    }
}

