/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui.helper;

import blusunrize.immersiveengineering.api.client.TextUtils;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mctmods.immersivetechnology.client.gui.helper.ITGuiHelper;
import mctmods.immersivetechnology.client.gui.helper.ITInfoArea;
import mctmods.immersivetechnology.client.renderer.helper.ITRenderTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ITFluidInfoArea
extends ITInfoArea {
    private final IFluidTank tank;
    private final Rect2i area;
    private final int overlayUMin;
    private final int overlayVMin;
    private final int overlayWidth;
    private final int overlayHeight;
    private final ResourceLocation overlayTexture;

    public ITFluidInfoArea(IFluidTank tank, Rect2i area, int overlayUMin, int overlayVMin, int overlayWidth, int overlayHeight, ResourceLocation overlayTexture) {
        super(area);
        this.tank = tank;
        this.area = area;
        this.overlayUMin = overlayUMin;
        this.overlayVMin = overlayVMin;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
        this.overlayTexture = overlayTexture;
    }

    @Override
    public void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        if (ModList.get().isLoaded("jei")) {
            return;
        }
        FluidStack fluid = this.tank.getFluid();
        int capacity = this.tank.getCapacity();
        Objects.requireNonNull(tooltip);
        ITFluidInfoArea.fillTooltip(fluid, capacity, tooltip::add);
    }

    public static void fillTooltip(FluidStack fluid, int tankCapacity, Consumer<Component> tooltip) {
        if (!fluid.isEmpty()) {
            tooltip.accept((Component)fluid.getDisplayName().m_6881_().m_130938_(fluid.getFluid().getFluidType().getRarity(fluid).getStyleModifier()));
        } else {
            tooltip.accept((Component)Component.m_237115_((String)"gui.immersiveengineering.empty"));
        }
        if (Minecraft.m_91087_().f_91066_.f_92125_ && !fluid.isEmpty()) {
            if (!Screen.m_96638_()) {
                tooltip.accept((Component)Component.m_237115_((String)"desc.immersiveengineering.info.holdShiftForInfo"));
            } else {
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Fluid Registry: " + String.valueOf(ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid())))), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Density: " + fluid.getFluid().getFluidType().getDensity(fluid))), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Temperature: " + fluid.getFluid().getFluidType().getTemperature(fluid))), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Viscosity: " + fluid.getFluid().getFluidType().getViscosity(fluid))), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("NBT Data: " + String.valueOf(fluid.getTag()))), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
            }
        }
        if (tankCapacity > 0) {
            tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)(fluid.getAmount() + "/" + tankCapacity + "mB")), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY}));
        } else if (tankCapacity == 0) {
            tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)(fluid.getAmount() + "mB")), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY}));
        }
    }

    @Override
    public void draw(GuiGraphics graphics) {
        FluidStack fluid = this.tank.getFluid();
        float capacity = this.tank.getCapacity();
        graphics.m_280168_().m_85836_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (!fluid.isEmpty()) {
            int fluidHeight = (int)((float)this.area.m_110091_() * ((float)fluid.getAmount() / capacity));
            ITGuiHelper.drawRepeatedFluidSpriteGui((MultiBufferSource)buffer, graphics.m_280168_(), fluid, this.area.m_110085_(), this.area.m_110086_() + this.area.m_110091_() - fluidHeight, this.area.m_110090_(), fluidHeight);
        }
        int xOff = (this.area.m_110090_() - this.overlayWidth) / 2;
        int yOff = (this.area.m_110091_() - this.overlayHeight) / 2;
        RenderType renderType = ITRenderTypes.getGui(this.overlayTexture);
        ITGuiHelper.drawTexturedRect(buffer.m_6299_(renderType), graphics.m_280168_(), this.area.m_110085_() + xOff, this.area.m_110086_() + yOff, this.overlayWidth, this.overlayHeight, 256.0f, this.overlayUMin, this.overlayUMin + this.overlayWidth, this.overlayVMin, this.overlayVMin + this.overlayHeight);
        buffer.m_109911_();
        graphics.m_280168_().m_85849_();
    }
}

