/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.helper;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import mctmods.immersivetechnology.client.models.helper.ITObjModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;

public class ITObjLoader
implements IGeometryLoader<ITObjModel> {
    public static final ITObjLoader INSTANCE = new ITObjLoader();

    private ITObjLoader() {
    }

    public ITObjModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
        if (!modelContents.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocationStr = modelContents.get("model").getAsString();
        ResourceLocation modelLocation = ResourceLocation.parse((String)modelLocationStr);
        boolean automaticCulling = GsonHelper.m_13855_((JsonObject)modelContents, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = GsonHelper.m_13855_((JsonObject)modelContents, (String)"shade_quads", (boolean)true);
        boolean flipV = GsonHelper.m_13855_((JsonObject)modelContents, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = GsonHelper.m_13855_((JsonObject)modelContents, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = GsonHelper.m_13851_((JsonObject)modelContents, (String)"mtl_override", null);
        HashMap<String, Boolean> visibility = new HashMap<String, Boolean>();
        if (modelContents.has("visibility")) {
            JsonObject visJson = modelContents.getAsJsonObject("visibility");
            for (Map.Entry entry : visJson.entrySet()) {
                visibility.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
            }
        }
        ObjModel.ModelSettings settings = new ObjModel.ModelSettings(modelLocation, automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride);
        ObjModel inner = ObjLoader.INSTANCE.loadModel(settings);
        return new ITObjModel(inner, visibility);
    }
}

