/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.items.helper;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockPartBlock;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlock;
import mctmods.immersivetechnology.common.blocks.helper.ITBlock;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ITBlockItem
extends BlockItem {
    public ITBlockItem(Block b, Item.Properties props) {
        super(b, props);
    }

    public ITBlockItem(Block b) {
        this(b, new Item.Properties());
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack stack) {
        return this.m_40614_().m_7705_();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag advanced) {
        FluidStack fs;
        ITBlock ieBlock;
        Block block = this.m_40614_();
        if (block instanceof ITBlock && (ieBlock = (ITBlock)block).hasFlavour()) {
            String flavourKey = "desc.immersivetechnology.flavour." + ieBlock.getNameForFlavour();
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)flavourKey), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY}));
        }
        super.m_7373_(stack, world, tooltip, advanced);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"energy")) {
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersivetechnology.info.energyStored", (Object[])new Object[]{ItemNBTHelper.getInt((ItemStack)stack, (String)"energy")}), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY}));
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundTag)ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"tank"))) != null) {
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersivetechnology.info.fluidStored", (Object[])new Object[]{fs.getDisplayName(), fs.getAmount()}), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY}));
        }
    }

    protected boolean m_7429_(@NotNull BlockPlaceContext context, @NotNull BlockState newState) {
        if (this.m_40614_() instanceof MultiblockPartBlock) {
            return false;
        }
        Block b = newState.m_60734_();
        if (b instanceof ITBaseBlock) {
            ITBaseBlock ieBlock = (ITBaseBlock)b;
            if (!ieBlock.canIEBlockBePlaced(newState, context)) {
                return false;
            }
            boolean ret = super.m_7429_(context, newState);
            if (ret) {
                ieBlock.onIEBlockPlacedBy(context, newState);
            }
            return ret;
        }
        return super.m_7429_(context, newState);
    }

    protected boolean m_7274_(@NotNull BlockPos pos, @NotNull Level worldIn, @Nullable Player player, @NotNull ItemStack stack, BlockState state) {
        if (!state.m_61138_((Property)ITProperties.MULTIBLOCKSLAVE)) {
            return super.m_7274_(pos, worldIn, player, stack, state);
        }
        return false;
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41784_()).m_128441_("Items")) {
            ListTag list = tag.m_128437_("Items", 10);
            NonNullList items = NonNullList.m_122779_();
            list.forEach(e -> {
                ItemStack s = ItemStack.m_41712_((CompoundTag)((CompoundTag)e));
                if (!s.m_41619_()) {
                    items.add((Object)s);
                }
            });
            return Optional.of(new BundleTooltip(items, 0));
        }
        return super.m_142422_(stack);
    }

    public boolean m_142095_() {
        ITBaseBlock ieBlock;
        Block block = this.m_40614_();
        return !(block instanceof ITBaseBlock) || (ieBlock = (ITBaseBlock)block).fitsIntoContainer();
    }
}

