/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.gui.helper;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ITSlot
extends Slot {
    final AbstractContainerMenu containerMenu;

    public ITSlot(AbstractContainerMenu containerMenu, Container inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.containerMenu = containerMenu;
    }

    private static class SlotItemHandlerIT
    extends SlotItemHandler {
        public SlotItemHandlerIT(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int m_5866_(@NotNull ItemStack stack) {
            return Math.min(this.m_6641_(), stack.m_41741_());
        }
    }

    public static class ItemHandlerGhost
    extends SlotItemHandlerIT {
        public ItemHandlerGhost(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    public static class Fuel
    extends SlotItemHandlerIT {
        public Fuel(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.getItemHandler().isItemValid(this.getSlotIndex(), stack);
        }
    }

    public static class FluidContainer
    extends SlotItemHandlerIT {
        int filter;

        public FluidContainer(IItemHandler inv, int id, int x, int y, int filter) {
            super(inv, id, x, y);
            this.filter = filter;
        }

        public boolean m_5857_(@NotNull ItemStack itemStack) {
            LazyOptional handlerCap = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return handlerCap.map(handler -> {
                if (handler.getTanks() <= 0) {
                    return false;
                }
                if (this.filter == 1) {
                    return handler.getFluidInTank(0).isEmpty();
                }
                if (this.filter == 2) {
                    return !handler.getFluidInTank(0).isEmpty();
                }
                return true;
            }).orElse(false);
        }
    }

    public static class Output
    extends SlotItemHandlerIT {
        public Output(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack itemStack) {
            return false;
        }
    }
}

