/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.api.MechanicalCapabilities;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyConsumer;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyProvider;
import mctmods.immersivetechnology.client.particles.ColoredSmoke;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.metal.process.RotationInertiaProcess;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SteamTurbineRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SteamTurbineShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SteamTurbineLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
ITPressurizedFluidOutput<State> {
    public static final int TANK_CAPACITY = 12000;
    public static final int MAX_SPEED = 7200;
    private static final double BASE_MASS = 10.0;
    private static final double DRIVE_TORQUE = 30.0;
    private static final double FRICTION = 60.0;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])SteamTurbineShape.DATA.pointsOfInterest);
    public static final BlockPos REDSTONE_POI = SteamTurbineLogic.getPosList("redstone").get(0);
    public static final BlockPos RUNNING_SOUND_POI = SteamTurbineLogic.getPosList("sound_running").get(0);
    public static final BlockPos SMOKE_POI = SteamTurbineLogic.getPosList("smoke").get(0);
    public static final CapabilityPosition INPUT_FLUID_POI = new CapabilityPosition(SteamTurbineLogic.getPosList("fluid_input").get(0), SteamTurbineLogic.getFacing("fluid_input"));
    public static final CapabilityPosition OUTPUT_FLUID_POI = new CapabilityPosition(SteamTurbineLogic.getPosList("fluid_output").get(0), SteamTurbineLogic.getFacing("fluid_output"));
    public static final CapabilityPosition ROTATIONAL_OUTPUT_POI = new CapabilityPosition(SteamTurbineLogic.getPosList("mech_output").get(0), SteamTurbineLogic.getFacing("mech_output"));
    public static final List<BlockPos> FLUID_OUTPUT_POIS = SteamTurbineLogic.getPosList("fluid_output");
    private static final RelativeBlockFace OUTPUT_FACING = SteamTurbineLogic.getFacing("fluid_output");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return FLUID_OUTPUT_POIS;
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return ctx.getLevel().toAbsolute(OUTPUT_FACING);
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return ImmutableList.of((Object)((Object)state.tanks.output));
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return ImmutableList.of(state.fluidOutput);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        float base;
        State state = (State)ctx.getState();
        float targetLevel = ITLib.remapRange(0.0f, 7200.0f, 0.5f, 1.0f, state.speed);
        state.currentLevel = state.currentLevel == 0.0f ? targetLevel : state.currentLevel * 0.9f + targetLevel * 0.1f;
        float targetPitch = ITLib.remapRange(0.0f, 7200.0f, 0.5f, 1.5f, state.speed);
        state.currentPitch = state.currentPitch == 0.0f ? targetPitch : state.currentPitch * 0.95f + targetPitch * 0.05f;
        if (state.currentPitch < 0.5f) {
            state.currentPitch = 0.5f;
        }
        float step = base = (float)state.speed / 7200.0f * 72.0f;
        if (state.animation_fanFadeIn > 0) {
            step -= (float)state.animation_fanFadeIn / 80.0f * base;
            --state.animation_fanFadeIn;
        }
        state.animation_fanRotationStep = step;
        state.animation_fanRotation += step;
        state.animation_fanRotation %= 360.0f;
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = ctx.getLevel().toAbsolute(new Vec3((double)RUNNING_SOUND_POI.m_123341_() + 0.5, (double)RUNNING_SOUND_POI.m_123342_() + 0.5, (double)RUNNING_SOUND_POI.m_123343_() + 0.5));
            state.isSoundPlaying = ITSound.startSound(() -> state.active || state.speed > 0, ctx.isValid(), soundPos, ITSounds.steamTurbine, () -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return Float.valueOf(0.0f);
                }
                float attenuation = (float)Math.max(player.m_20238_(soundPos) / 32.0, 1.0);
                return Float.valueOf(11.0f * (state.currentLevel - 0.5f) / attenuation);
            }, () -> Float.valueOf(state.currentPitch));
        }
        if (state.active && ctx.getLevel().shouldTickModulo(2)) {
            Direction facing = ctx.getLevel().getOrientation().front();
            BlockPos outputAbs = ctx.getLevel().toAbsolute(SMOKE_POI);
            boolean connected = state.fluidOutput.isPresent();
            if (!connected) {
                Vec3 smokePos = new Vec3((double)outputAbs.m_123341_() + 0.5, (double)outputAbs.m_123342_() + 0.5, (double)outputAbs.m_123343_() + 0.5);
                float normSpeed = Math.max(0.0f, ITLib.remapRange(100.0f, 7200.0f, 0.0f, 1.0f, state.speed));
                double dirVelHoriz = 0.125 * (double)normSpeed;
                double dirVelVert = 0.1 * (double)normSpeed;
                double baseUp = 0.0625 + 0.1 * (double)(1.0f - normSpeed);
                double velX = (double)facing.m_122429_() * dirVelHoriz + SteamTurbineLogic.particleXZSpeed();
                double velY = (double)facing.m_122430_() * dirVelVert + baseUp;
                double velZ = (double)facing.m_122431_() * dirVelHoriz + SteamTurbineLogic.particleXZSpeed();
                FluidStack outFluid = state.tanks.output.getFluid();
                float r = 0.5f;
                float g = 0.5f;
                float b = 0.5f;
                if (!outFluid.isEmpty()) {
                    int tint = IClientFluidTypeExtensions.of((Fluid)outFluid.getFluid()).getTintColor(outFluid);
                    r = (float)(tint >> 16 & 0xFF) / 255.0f;
                    g = (float)(tint >> 8 & 0xFF) / 255.0f;
                    b = (float)(tint & 0xFF) / 255.0f;
                }
                Level level = ctx.getLevel().getRawLevel();
                level.m_7107_((ParticleOptions)new ColoredSmoke(r, g, b), smokePos.f_82479_, smokePos.f_82480_, smokePos.f_82481_, velX, velY, velZ);
            }
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean triggerRelease;
        LazyOptional consumerCap;
        this.pumpOutputs(ctx);
        State state = (State)ctx.getState();
        boolean previouslyActive = state.active;
        int previousSpeed = state.speed;
        boolean currentlyEnabled = state.rsState.isEnabled(ctx);
        state.active = false;
        Level level = ctx.getLevel().getRawLevel();
        Direction outputFacing = ctx.getLevel().getOrientation().front();
        BlockPos outputPortAbs = ctx.getLevel().toAbsolute(ROTATIONAL_OUTPUT_POI.posInMultiblock());
        BlockPos consumerAbsPos = outputPortAbs.m_121945_(outputFacing);
        BlockEntity entity = level.m_7702_(consumerAbsPos);
        boolean hasConsumer = false;
        double additionalMass = 0.0;
        double additionalFriction = 0.0;
        if (entity != null && (consumerCap = entity.getCapability(MechanicalCapabilities.MECHANICAL_CONSUMER_CAPABILITY, outputFacing.m_122424_())).isPresent()) {
            hasConsumer = true;
            IMechanicalEnergyConsumer consumer = (IMechanicalEnergyConsumer)consumerCap.orElseThrow(RuntimeException::new);
            additionalMass = consumer.getMass();
            additionalFriction = consumer.getFriction();
        }
        if (additionalMass != state.connectedMass || additionalFriction != state.connectedFriction) {
            state.connectedMass = additionalMass;
            state.connectedFriction = additionalFriction;
            state.inertia = new RotationInertiaProcess(10.0 + state.connectedMass, 30.0, 60.0 + state.connectedFriction);
        }
        boolean canRun = currentlyEnabled && hasConsumer;
        int prevBurnRemaining = state.burnRemaining;
        if (!canRun) {
            state.burnRemaining = 0;
            state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
        } else if (state.burnRemaining > 0) {
            --state.burnRemaining;
            state.speed = Math.min(7200, state.speed + state.inertia.getSpeedUpRate());
            state.active = true;
        } else {
            FluidStack fluid = state.tanks.input.getFluid();
            SteamTurbineRecipe recipe = state.recipeGetter.apply(ctx.getLevel().getRawLevel(), fluid);
            if (recipe != null && fluid.getAmount() >= recipe.input.getAmount()) {
                int filled;
                state.tanks.input.drain(recipe.input.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                if (recipe.fluidOutput == null || (filled = state.tanks.output.fill(recipe.fluidOutput, IFluidHandler.FluidAction.EXECUTE)) < recipe.fluidOutput.getAmount()) {
                    // empty if block
                }
                state.burnRemaining = recipe.getTotalProcessTime() - 1;
                state.speed = Math.min(7200, state.speed + state.inertia.getSpeedUpRate());
                state.active = true;
            } else {
                state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
            }
        }
        if (state.pressureReleaseCooldown > 0) {
            --state.pressureReleaseCooldown;
        }
        boolean bl = triggerRelease = !state.wasEnabled && currentlyEnabled;
        if (prevBurnRemaining == 0 && state.burnRemaining > 0) {
            triggerRelease = true;
        }
        if (triggerRelease && state.pressureReleaseCooldown <= 0) {
            BlockPos soundPos = ctx.getLevel().toAbsolute(RUNNING_SOUND_POI);
            level.m_5594_(null, soundPos, (SoundEvent)ITSounds.pressure_release.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            state.pressureReleaseCooldown = 200;
        }
        state.wasEnabled = currentlyEnabled;
        if (previouslyActive != state.active || state.speed % 5 == 0 || previousSpeed != state.speed) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private static double particleXZSpeed() {
        return ApiUtils.RANDOM.nextDouble(-0.015625, 0.015625);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equals((Object)INPUT_FLUID_POI)) {
                return state.fluidCap.cast(ctx);
            }
            if (position.equals((Object)OUTPUT_FLUID_POI)) {
                return state.fluidCapExhaust.cast(ctx);
            }
        }
        if (cap == MechanicalCapabilities.MECHANICAL_PROVIDER_CAPABILITY && position.equals((Object)ROTATIONAL_OUTPUT_POI)) {
            return LazyOptional.of(() -> new MechanicalEnergyProvider(state)).cast();
        }
        return LazyOptional.empty();
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return SteamTurbineShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final SteamTurbineTank tanks;
        public final StoredCapability<IFluidHandler> fluidCap;
        public final StoredCapability<IFluidHandler> fluidCapExhaust;
        public final CapabilityReference<IFluidHandler> fluidOutput;
        private final BiFunction<Level, FluidStack, SteamTurbineRecipe> recipeGetter;
        public int speed = 0;
        public boolean active = false;
        private int burnRemaining = 0;
        public BooleanSupplier isSoundPlaying = () -> false;
        public float animation_fanRotationStep = 0.0f;
        public float animation_fanRotation = 0.0f;
        private transient int animation_fanFadeIn = 0;
        private transient float currentLevel = 0.0f;
        private transient float currentPitch = 0.0f;
        private double connectedMass = 0.0;
        private double connectedFriction = 0.0;
        private RotationInertiaProcess inertia;
        private int pressureReleaseCooldown = 0;
        private boolean wasEnabled = false;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new SteamTurbineTank(v -> onChanged.run());
            this.fluidCap = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.input, false, true, onChanged));
            this.fluidCapExhaust = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.output, true, false, onChanged));
            this.recipeGetter = CachedRecipe.cached(SteamTurbineRecipe::findRecipe);
            MultiblockFace outputMBFace = new MultiblockFace(OUTPUT_FACING, FLUID_OUTPUT_POIS.get(0));
            CapabilityPosition oppCp = CapabilityPosition.opposing((MultiblockFace)outputMBFace);
            MultiblockFace oppMbf = new MultiblockFace(oppCp.side(), oppCp.posInMultiblock());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, oppMbf);
            this.inertia = new RotationInertiaProcess(10.0, 30.0, 60.0);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128405_("speed", this.speed);
            nbt.m_128379_("active", this.active);
            nbt.m_128405_("burnRemaining", this.burnRemaining);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128405_("pressureReleaseCooldown", this.pressureReleaseCooldown);
            nbt.m_128379_("wasEnabled", this.wasEnabled);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.speed = nbt.m_128451_("speed");
            this.active = nbt.m_128471_("active");
            this.burnRemaining = nbt.m_128451_("burnRemaining");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.pressureReleaseCooldown = nbt.m_128451_("pressureReleaseCooldown");
            this.wasEnabled = nbt.m_128471_("wasEnabled");
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return null;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tanks.input, this.tanks.output};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128405_("speed", this.speed);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            boolean oldActive = this.active;
            this.active = nbt.m_128471_("active");
            this.speed = nbt.m_128451_("speed");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            if (this.active && !oldActive) {
                this.animation_fanFadeIn = 80;
            }
        }
    }

    public record SteamTurbineTank(ITMarkableFluidTank input, ITMarkableFluidTank output) {
        public SteamTurbineTank(Consumer<Void> markDirty) {
            this(new ITMarkableFluidTank(12000, markDirty), new ITMarkableFluidTank(12000, markDirty));
        }

        public static SteamTurbineTank makeClient() {
            return new SteamTurbineTank(v -> {});
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("input", (Tag)this.input.writeToNBT(new CompoundTag()));
            tag.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.input.readFromNBT(tag.m_128469_("input"));
            this.output.readFromNBT(tag.m_128469_("output"));
        }

        public int getCapacity() {
            return 12000;
        }
    }

    private record MechanicalEnergyProvider(State state) implements IMechanicalEnergyProvider
    {
        @Override
        public int getSpeed() {
            return this.state.speed;
        }

        @Override
        public float getTorque() {
            return 1.0f;
        }

        @Override
        public int getMaxSpeed() {
            return 7200;
        }

        @Override
        public double getBaseMass() {
            return 10.0;
        }

        @Override
        public double getDriveTorque() {
            return 30.0;
        }

        @Override
        public double getFriction() {
            return 60.0;
        }
    }
}

