/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import mctmods.immersivetechnology.core.registration.ITRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BoilerLiquidRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<BoilerLiquidRecipe>> SERIALIZER;
    public static final CachedRecipeList<BoilerLiquidRecipe> RECIPES;
    public final FluidTagInput input;
    private final int time;
    private final double heatPerTick;
    Lazy<Integer> totalProcessTime;

    public BoilerLiquidRecipe(ResourceLocation id, FluidTagInput input, int time, double heatPerTick) {
        super(Lazy.of(() -> ItemStack.f_41583_), ITRecipeTypes.BOILER_LIQUID, id);
        this.input = input;
        this.time = time;
        this.heatPerTick = heatPerTick;
        this.totalProcessTime = Lazy.of(() -> this.time);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.input});
    }

    public static BoilerLiquidRecipe findRecipe(Level level, FluidStack input) {
        for (BoilerLiquidRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public int getTotalProcessEnergy() {
        return 0;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public double getHeatPerTick() {
        return this.heatPerTick;
    }

    static {
        RECIPES = new CachedRecipeList(ITRecipeTypes.BOILER_LIQUID);
    }
}

