/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import mctmods.immersivetechnology.core.registration.ITRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BoilerTankRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<BoilerTankRecipe>> SERIALIZER;
    public static final CachedRecipeList<BoilerTankRecipe> RECIPES;
    public final FluidTagInput input;
    public final FluidStack output;
    Lazy<Integer> totalProcessTime;

    public BoilerTankRecipe(ResourceLocation id, FluidTagInput input, FluidStack output, int time) {
        super(LAZY_EMPTY, ITRecipeTypes.BOILER_TANK, id);
        this.input = input;
        this.output = output;
        this.totalProcessTime = Lazy.of(() -> time);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.input});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public static BoilerTankRecipe findRecipe(Level level, FluidStack input) {
        for (BoilerTankRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public int getTotalProcessEnergy() {
        return 0;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList(ITRecipeTypes.BOILER_TANK);
    }
}

