/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe.serializer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.DistillerRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistillerRecipeSerializer
extends IERecipeSerializer<DistillerRecipe> {
    public ItemStack getIcon() {
        return ITMultiblockProvider.DISTILLER.iconStack();
    }

    public DistillerRecipe readFromJson(ResourceLocation recipeID, JsonObject json, ICondition.IContext iContext) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        FluidStack fluidOutput = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        ItemStack itemOutput = ItemStack.f_41583_;
        float chance = 0.0f;
        if (json.has("item_output")) {
            JsonObject itemJson = GsonHelper.m_13930_((JsonObject)json, (String)"item_output");
            itemOutput = ShapedRecipe.m_151274_((JsonObject)itemJson);
            if (itemJson.has("chance")) {
                chance = GsonHelper.m_13820_((JsonObject)itemJson, (String)"chance", (float)0.0f);
            }
        }
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        return new DistillerRecipe(recipeID, input, fluidOutput, itemOutput, chance, time, energy);
    }

    @Nullable
    public DistillerRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        FluidStack fluidOutput = buffer.readFluidStack();
        boolean hasItem = buffer.readBoolean();
        ItemStack itemOutput = hasItem ? buffer.m_130267_() : ItemStack.f_41583_;
        float chance = hasItem ? buffer.readFloat() : 0.0f;
        int time = buffer.readInt();
        int energy = buffer.readInt();
        return new DistillerRecipe(recipeId, input, fluidOutput, itemOutput, chance, time, energy);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, DistillerRecipe recipe) {
        recipe.input.write(buffer);
        buffer.writeFluidStack(recipe.fluidOutput);
        boolean hasItem = !recipe.itemOutput.m_41619_();
        buffer.writeBoolean(hasItem);
        if (hasItem) {
            buffer.m_130055_(recipe.itemOutput);
            buffer.writeFloat(recipe.chance);
        }
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

