/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.network;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mctmods.immersivetechnology.common.gui.helper.ITContainerMenu;
import mctmods.immersivetechnology.common.gui.helper.ITGenericDataSerializers;
import mctmods.immersivetechnology.common.network.ITMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record ITMessageContainerData(List<Pair<Integer, ITGenericDataSerializers.DataPair<?>>> synced) implements ITMessage
{
    public ITMessageContainerData(FriendlyByteBuf buf) {
        this(ITMessageContainerData.readSynced(buf));
    }

    private static List<Pair<Integer, ITGenericDataSerializers.DataPair<?>>> readSynced(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList synced = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            int index = buf.m_130242_();
            ITGenericDataSerializers.DataPair<?> dataPair = ITGenericDataSerializers.read(buf);
            synced.add(Pair.of((Object)index, dataPair));
        }
        return synced;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.synced.size());
        for (Pair<Integer, ITGenericDataSerializers.DataPair<?>> pair : this.synced) {
            buf.m_130130_(((Integer)pair.getFirst()).intValue());
            ((ITGenericDataSerializers.DataPair)pair.getSecond()).write(buf);
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            assert (Minecraft.m_91087_().f_91074_ != null);
            AbstractContainerMenu currentContainer = Minecraft.m_91087_().f_91074_.f_36096_;
            if (currentContainer instanceof ITContainerMenu) {
                ITContainerMenu itContainer = (ITContainerMenu)currentContainer;
                itContainer.receiveSync(this.synced);
            }
        });
    }
}

