/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.solarregistry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mctmods.immersivetechnology.common.util.solarregistry.SolarRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class SolarRegistryData
extends SavedData {
    public final Map<Integer, Set<BlockPos>> towerBasesByY = new HashMap<Integer, Set<BlockPos>>();
    public final Map<Integer, Set<BlockPos>> reflectorPOIsByY = new HashMap<Integer, Set<BlockPos>>();
    public final Set<BlockPos> untakenReflectors = new HashSet<BlockPos>();
    public boolean groupsDirty = true;
    public final Map<BlockPos, BlockPos> parent = new HashMap<BlockPos, BlockPos>();
    public final Map<BlockPos, Integer> rank = new HashMap<BlockPos, Integer>();
    public final Map<BlockPos, SolarRegistry.GroupData> groupData = new HashMap<BlockPos, SolarRegistry.GroupData>();

    public static SolarRegistryData load(CompoundTag nbt) {
        SolarRegistryData data = new SolarRegistryData();
        for (String key : nbt.m_128431_()) {
            HashSet<BlockPos> set;
            ListTag list;
            int y;
            if (key.startsWith("towers_")) {
                y = Integer.parseInt(key.substring(7));
                list = nbt.m_128437_(key, 10);
                set = new HashSet<BlockPos>();
                for (Tag tag : list) {
                    set.add(BlockPos.m_122022_((long)((CompoundTag)tag).m_128454_("pos")));
                }
                if (set.isEmpty()) continue;
                data.towerBasesByY.put(y, set);
                continue;
            }
            if (!key.startsWith("reflectors_")) continue;
            y = Integer.parseInt(key.substring(11));
            list = nbt.m_128437_(key, 10);
            set = new HashSet();
            for (Tag tag : list) {
                set.add(BlockPos.m_122022_((long)((CompoundTag)tag).m_128454_("pos")));
            }
            if (set.isEmpty()) continue;
            data.reflectorPOIsByY.put(y, set);
        }
        if (nbt.m_128441_("untaken")) {
            ListTag list = nbt.m_128437_("untaken", 4);
            for (Tag tag : list) {
                data.untakenReflectors.add(BlockPos.m_122022_((long)((LongTag)tag).m_7046_()));
            }
        }
        if (nbt.m_128441_("groups")) {
            ListTag groups = nbt.m_128437_("groups", 10);
            for (Tag t : groups) {
                CompoundTag tag = (CompoundTag)t;
                BlockPos leader = BlockPos.m_122022_((long)tag.m_128454_("leader"));
                SolarRegistry.GroupData gd = new SolarRegistry.GroupData();
                gd.danceStartTick = tag.m_128454_("danceStartTick");
                gd.pendingTick = tag.m_128454_("pendingTick");
                gd.animationPhase = tag.m_128451_("animationPhase");
                gd.groupSize = tag.m_128451_("groupSize");
                data.groupData.put(leader, gd);
            }
        }
        data.groupsDirty = true;
        return data;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        CompoundTag tag;
        ListTag list;
        for (Map.Entry<Integer, Set<BlockPos>> entry : this.towerBasesByY.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            list = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                tag = new CompoundTag();
                tag.m_128356_("pos", pos.m_121878_());
                list.add((Object)tag);
            }
            nbt.m_128365_("towers_" + String.valueOf(entry.getKey()), (Tag)list);
        }
        for (Map.Entry<Integer, Set<BlockPos>> entry : this.reflectorPOIsByY.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            list = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                tag = new CompoundTag();
                tag.m_128356_("pos", pos.m_121878_());
                list.add((Object)tag);
            }
            nbt.m_128365_("reflectors_" + String.valueOf(entry.getKey()), (Tag)list);
        }
        if (!this.untakenReflectors.isEmpty()) {
            ListTag untakenList = new ListTag();
            for (BlockPos pos : this.untakenReflectors) {
                untakenList.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
            }
            nbt.m_128365_("untaken", (Tag)untakenList);
        }
        if (!this.groupData.isEmpty()) {
            nbt.m_128365_("groups", (Tag)this.createGroupsTag());
        }
        return nbt;
    }

    private ListTag createGroupsTag() {
        ListTag groups = new ListTag();
        for (Map.Entry<BlockPos, SolarRegistry.GroupData> entry : this.groupData.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("leader", entry.getKey().m_121878_());
            tag.m_128356_("danceStartTick", entry.getValue().danceStartTick);
            tag.m_128356_("pendingTick", entry.getValue().pendingTick);
            tag.m_128405_("animationPhase", entry.getValue().animationPhase);
            tag.m_128405_("groupSize", entry.getValue().groupSize);
            groups.add((Object)tag);
        }
        return groups;
    }
}

