/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui;

import mctmods.immersivetechnology.common.blocks.metal.gui.ValveLoadMenu;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.network.ITMessageTileSync;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class ValveLoadScreen
extends AbstractContainerScreen<ValveLoadMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"textures/gui/valve.png");
    private final ValveCommonBlockEntity tile;
    private EditBox packetLimitField;
    private EditBox timeLimitField;
    private EditBox keepSizeField;
    private int prevPacketLimit = Integer.MIN_VALUE;
    private int prevTimeLimit = Integer.MIN_VALUE;
    private int prevKeepSize = Integer.MIN_VALUE;

    public ValveLoadScreen(ValveLoadMenu menu, Inventory inv) {
        super((AbstractContainerMenu)menu, inv, (Component)Component.m_237119_());
        this.tile = menu.tile;
        this.f_97726_ = 216;
        this.f_97727_ = 112;
        this.f_97731_ = -1000;
        this.f_97729_ = -1000;
    }

    private boolean isValidInput(String s) {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.packetLimitField = new EditBox(this.f_96547_, this.f_97735_ + 23, this.f_97736_ + 30, 50, 9, (Component)Component.m_237119_());
        this.packetLimitField.m_94153_(this::isValidInput);
        this.packetLimitField.m_94182_(false);
        this.m_142416_((GuiEventListener)this.packetLimitField);
        this.timeLimitField = new EditBox(this.f_96547_, this.f_97735_ + 23, this.f_97736_ + 48, 50, 9, (Component)Component.m_237119_());
        this.timeLimitField.m_94153_(this::isValidInput);
        this.timeLimitField.m_94182_(false);
        this.m_142416_((GuiEventListener)this.timeLimitField);
        this.keepSizeField = new EditBox(this.f_96547_, this.f_97735_ + 23, this.f_97736_ + 66, 50, 9, (Component)Component.m_237119_());
        this.keepSizeField.m_94153_(this::isValidInput);
        this.keepSizeField.m_94182_(false);
        this.m_142416_((GuiEventListener)this.keepSizeField);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)TranslationKey.GUI_APPLY.location), btn -> this.apply()).m_252987_(this.f_97735_ + (this.f_97726_ / 2 - 20), this.f_97736_ + 90, 40, 20).m_253136_());
        this.updateFields();
    }

    private void updateFields() {
        int ks;
        int tl;
        int pl = ((ValveLoadMenu)this.f_97732_).getPacketLimit();
        if (pl != this.prevPacketLimit) {
            this.packetLimitField.m_94144_(pl == -1 ? "" : String.valueOf(pl));
            this.prevPacketLimit = pl;
        }
        if ((tl = ((ValveLoadMenu)this.f_97732_).getTimeLimit()) != this.prevTimeLimit) {
            this.timeLimitField.m_94144_(tl == -1 ? "" : String.valueOf(tl));
            this.prevTimeLimit = tl;
        }
        if ((ks = ((ValveLoadMenu)this.f_97732_).getKeepSize()) != this.prevKeepSize) {
            this.keepSizeField.m_94144_(ks == -1 ? "" : String.valueOf(ks));
            this.prevKeepSize = ks;
        }
    }

    private void apply() {
        String plStr = this.packetLimitField.m_94155_();
        int pl = plStr.isEmpty() || plStr.equals("-") ? -1 : Integer.parseInt(plStr);
        String tlStr = this.timeLimitField.m_94155_();
        int tl = tlStr.isEmpty() || tlStr.equals("-") ? -1 : Integer.parseInt(tlStr);
        String ksStr = this.keepSizeField.m_94155_();
        int ks = ksStr.isEmpty() || ksStr.equals("-") ? -1 : Integer.parseInt(ksStr);
        CompoundTag message = new CompoundTag();
        message.m_128405_("packetLimit", pl);
        message.m_128405_("timeLimit", tl);
        message.m_128405_("keepSize", ks);
        ITPacketHandler.sendToServer(new ITMessageTileSync(this.tile.m_58899_(), message));
        Minecraft.m_91087_().m_91152_(null);
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateFields();
    }

    public void m_7379_() {
        super.m_7379_();
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float pt, int mx, int my) {
        this.m_280273_(graphics);
        graphics.m_280398_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0.0f, 0.0f, this.f_97726_, 88, this.f_97726_, 88);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mx, int my, float pt) {
        super.m_88315_(graphics, mx, my, pt);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)TranslationKey.GUI_VALVE_FIRST_LINE.location), this.f_97735_ + 23, this.f_97736_ + 14, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)TranslationKey.GUI_VALVE_LOAD_LIMIT_PACKET.location), this.packetLimitField.m_252754_() + 54, this.packetLimitField.m_252907_(), 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)TranslationKey.GUI_VALVE_LOAD_LIMIT_TIME.location), this.timeLimitField.m_252754_() + 54, this.timeLimitField.m_252907_(), 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)TranslationKey.GUI_VALVE_LOAD_LIMIT_DESTINATION.location), this.keepSizeField.m_252754_() + 54, this.keepSizeField.m_252907_(), 0xFFFFFF, false);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mx, int my) {
    }
}

