/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Objects;
import mctmods.immersivetechnology.core.registration.ITParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ColoredSmoke
implements ParticleOptions {
    public static final Codec<ColoredSmoke> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.x())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.y())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.z())), (App)Codec.BOOL.optionalFieldOf("collide_horizontal", (Object)false).forGetter(d -> d.collideHorizontal), (App)Codec.BOOL.optionalFieldOf("collide_vertical", (Object)false).forGetter(d -> d.collideVertical)).apply((Applicative)inst, ColoredSmoke::new));
    public static final ParticleOptions.Deserializer<ColoredSmoke> DESERIALIZER = new ParticleOptions.Deserializer<ColoredSmoke>(){

        @NotNull
        public ColoredSmoke fromCommand(@NotNull ParticleType<ColoredSmoke> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            boolean collideHorizontal = false;
            boolean collideVertical = false;
            if (reader.canRead()) {
                reader.expect(' ');
                collideHorizontal = reader.readBoolean();
                if (reader.canRead()) {
                    reader.expect(' ');
                    collideVertical = reader.readBoolean();
                }
            }
            return new ColoredSmoke(r, g, b, collideHorizontal, collideVertical);
        }

        @NotNull
        public ColoredSmoke fromNetwork(@NotNull ParticleType<ColoredSmoke> type, FriendlyByteBuf buf) {
            return new ColoredSmoke(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readBoolean());
        }
    };
    public final Vector3f color;
    public final boolean collideHorizontal;
    public final boolean collideVertical;

    public ColoredSmoke(float r, float g, float b) {
        this(r, g, b, false, false);
    }

    public ColoredSmoke(float r, float g, float b, boolean collideHorizontal, boolean collideVertical) {
        this.color = new Vector3f(r, g, b);
        this.collideHorizontal = collideHorizontal;
        this.collideVertical = collideVertical;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ITParticles.COLORED_SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.color.x());
        buf.writeFloat(this.color.y());
        buf.writeFloat(this.color.z());
        buf.writeBoolean(this.collideHorizontal);
        buf.writeBoolean(this.collideVertical);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %b %b", Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_())), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), this.collideHorizontal, this.collideVertical);
    }
}

