/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.renderer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mctmods.immersivetechnology.client.models.RotorModels;
import mctmods.immersivetechnology.client.models.helper.ITDynamicModel;
import mctmods.immersivetechnology.client.renderer.helper.ITBaseBlockEntityRenderer;
import mctmods.immersivetechnology.client.renderer.helper.ITRenderUtils;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SteamTurbineLogic;
import mctmods.immersivetechnology.core.ITClientConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public class SteamTurbineRenderer
extends ITBaseBlockEntityRenderer<MultiblockBlockEntityMaster<SteamTurbineLogic.State>> {
    public void render(@NotNull MultiblockBlockEntityMaster<SteamTurbineLogic.State> tile, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!ITClientConfig.doSpecialRenderSteamTurbine) {
            return;
        }
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        SteamTurbineLogic.State state = (SteamTurbineLogic.State)context.getState();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        Vec3 axisVec = Vec3.m_82528_((Vec3i)dir.m_122436_());
        double angle = state.animation_fanRotation + state.animation_fanRotationStep * partialTicks;
        ITDynamicModel selectedModel = dir == Direction.EAST || dir == Direction.WEST ? RotorModels.ROTOR_EAST_WEST : RotorModels.ROTOR;
        Vec3 rotorStart1 = Vec3.m_82528_((Vec3i)context.getLevel().toAbsolute(new BlockPos(1, 1, 0)).m_121996_((Vec3i)pos));
        Vec3 delta1 = rotorStart1.m_82549_(axisVec.m_82490_(0.0));
        poseStack.m_85836_();
        poseStack.m_85837_(delta1.f_82479_ + 0.5, delta1.f_82480_ + 0.5, delta1.f_82481_ + 0.5);
        poseStack.m_252781_(new Quaternionf().rotateAxis((float)(angle * 0.01745329238474369), (Vector3fc)axisVec.m_252839_()));
        this.renderDynamicModel(selectedModel, poseStack, buffer, level, pos, packedLight);
        poseStack.m_85849_();
        Vec3 rotorStart2 = Vec3.m_82528_((Vec3i)context.getLevel().toAbsolute(new BlockPos(1, 1, 5)).m_121996_((Vec3i)pos));
        Vec3 delta2 = rotorStart2.m_82549_(axisVec.m_82490_(0.0));
        poseStack.m_85836_();
        poseStack.m_85837_(delta2.f_82479_ + 0.5, delta2.f_82480_ + 0.5, delta2.f_82481_ + 0.5);
        poseStack.m_252781_(new Quaternionf().rotateAxis((float)(angle * 0.01745329238474369), (Vector3fc)axisVec.m_252839_()));
        this.renderDynamicModel(selectedModel, poseStack, buffer, level, pos, packedLight);
        poseStack.m_85849_();
    }

    private void renderDynamicModel(ITDynamicModel model, PoseStack matrix, MultiBufferSource buffer, Level level, BlockPos pos, int light) {
        matrix.m_85836_();
        List quads = model.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        ITRenderUtils.renderModelTESRFancy(quads, buffer.m_6299_(RenderType.m_110451_()), matrix, level, pos, false, 0xFFFFFF, light);
        matrix.m_85849_();
    }
}

