/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.renderer.helper;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.List;
import mctmods.immersivetechnology.core.ITClientConfig;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ITRenderUtils {
    private static final Vector4f[] quadCoords = new Vector4f[4];
    private static final int[][] neighbourBrightness = new int[2][6];
    private static final float[][] normalizationFactors = new float[2][8];
    private static final VertexFormat FORMAT = DefaultVertexFormat.f_85811_;
    private static final int VERTEX_SIZE = FORMAT.m_86017_();
    private static final int UV_OFFSET = ITRenderUtils.findTextureOffset();
    private static final int POSITION_OFFSET = ITRenderUtils.findPositionOffset();

    public static void renderModelTESRFancy(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, Level world, BlockPos pos, boolean useCached, int color, int light) {
        if (ITClientConfig.disableFancyTESR) {
            ITRenderUtils.renderModelTESRFast(quads, renderer, transform, -1, LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos), OverlayTexture.f_118083_);
        } else {
            if (!useCached) {
                for (Direction f : DirectionUtils.VALUES) {
                    int val = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos.m_121945_(f));
                    ITRenderUtils.neighbourBrightness[0][f.m_122411_()] = val >> 16 & 0xFF;
                    ITRenderUtils.neighbourBrightness[1][f.m_122411_()] = val & 0xFF;
                }
                for (int type = 0; type < 2; ++type) {
                    for (int i = 0; i < 8; ++i) {
                        ITRenderUtils.normalizationFactors[type][i] = (float)Math.sqrt(ITRenderUtils.computeSSquared(type, i));
                    }
                }
            }
            int[] rgba = new int[]{255, 255, 255, 255};
            if (color >= 0) {
                rgba[0] = color >> 16 & 0xFF;
                rgba[1] = color >> 8 & 0xFF;
                rgba[2] = color & 0xFF;
            }
            Matrix4f positionTransform = transform.m_85850_().m_252922_();
            Matrix3f normalTransform = transform.m_85850_().m_252943_();
            for (BakedQuad quad : quads) {
                int[] vData = quad.m_111303_();
                for (int i = 0; i < 4; ++i) {
                    quadCoords[i].set(Float.intBitsToFloat(vData[VERTEX_SIZE * i + POSITION_OFFSET]), Float.intBitsToFloat(vData[VERTEX_SIZE * i + POSITION_OFFSET + 1]), Float.intBitsToFloat(vData[VERTEX_SIZE * i + POSITION_OFFSET + 2]), 1.0f);
                }
                Vector3f normal = new Vector3f(ITRenderUtils.quadCoords[1].x, ITRenderUtils.quadCoords[1].y, ITRenderUtils.quadCoords[1].z);
                Vector3f side2 = new Vector3f(ITRenderUtils.quadCoords[2].x, ITRenderUtils.quadCoords[2].y, ITRenderUtils.quadCoords[2].z);
                normal.add(-quadCoords[3].x(), -quadCoords[3].y(), -quadCoords[3].z());
                side2.add(-quadCoords[0].x(), -quadCoords[0].y(), -quadCoords[0].z());
                normal.cross((Vector3fc)side2);
                normal.normalize();
                int l1 = ITRenderUtils.getLightValue(neighbourBrightness[1], normalizationFactors[1], light & 0xFF, normal);
                int l2 = ITRenderUtils.getLightValue(neighbourBrightness[0], normalizationFactors[0], light >> 16 & 0xFF, normal);
                normal.mul((Matrix3fc)normalTransform);
                for (int i = 0; i < 4; ++i) {
                    Vector4f vertexPos = quadCoords[i];
                    vertexPos.mul((Matrix4fc)positionTransform);
                    renderer.m_5954_(vertexPos.x(), vertexPos.y(), vertexPos.z(), (float)rgba[0] / 255.0f, (float)rgba[1] / 255.0f, (float)rgba[2] / 255.0f, (float)rgba[3] / 255.0f, Float.intBitsToFloat(vData[VERTEX_SIZE * i + UV_OFFSET]), Float.intBitsToFloat(vData[VERTEX_SIZE * i + UV_OFFSET + 1]), OverlayTexture.f_118083_, LightTexture.m_109885_((int)(l1 >> 4), (int)(l2 >> 4)), normal.x(), normal.y(), normal.z());
                }
            }
        }
    }

    private static int getLightValue(int[] neighbourBrightness, float[] normalizationFactors, int localBrightness, Vector3f normal) {
        double sideBrightness;
        byte type = 0;
        if (normal.x() > 0.0f) {
            sideBrightness = normal.x() * (float)neighbourBrightness[5];
            type = (byte)(type | 1);
        } else {
            sideBrightness = -normal.x() * (float)neighbourBrightness[4];
        }
        if (normal.y() > 0.0f) {
            sideBrightness += (double)(normal.y() * (float)neighbourBrightness[1]);
            type = (byte)(type | 2);
        } else {
            sideBrightness += (double)(-normal.y() * (float)neighbourBrightness[0]);
        }
        if (normal.z() > 0.0f) {
            sideBrightness += (double)(normal.z() * (float)neighbourBrightness[3]);
            type = (byte)(type | 4);
        } else {
            sideBrightness += (double)(-normal.z() * (float)neighbourBrightness[2]);
        }
        return (int)(((double)localBrightness + sideBrightness / (double)normalizationFactors[type]) / 2.0);
    }

    private static float scaledSquared(int val) {
        return (float)val / 255.0f * ((float)val / 255.0f);
    }

    private static float computeSSquared(int type, int i) {
        float sSquared = 0.0f;
        sSquared = (i & 1) != 0 ? (sSquared += ITRenderUtils.scaledSquared(neighbourBrightness[type][5])) : (sSquared += ITRenderUtils.scaledSquared(neighbourBrightness[type][4]));
        sSquared = (i & 2) != 0 ? (sSquared += ITRenderUtils.scaledSquared(neighbourBrightness[type][1])) : (sSquared += ITRenderUtils.scaledSquared(neighbourBrightness[type][0]));
        sSquared = (i & 4) != 0 ? (sSquared += ITRenderUtils.scaledSquared(neighbourBrightness[type][3])) : (sSquared += ITRenderUtils.scaledSquared(neighbourBrightness[type][2]));
        return sSquared;
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, int color, int light, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (color >= 0) {
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
        }
        for (BakedQuad quad : quads) {
            renderer.m_85987_(transform.m_85850_(), quad, red, green, blue, light, overlay);
        }
    }

    private static int findOffset(VertexFormatElement.Usage u) {
        int offset = 0;
        for (VertexFormatElement element : FORMAT.m_86023_()) {
            assert (element != null);
            if (element.m_86048_() == u && element.m_86041_() == VertexFormatElement.Type.FLOAT) {
                Preconditions.checkState((offset % 4 == 0 ? 1 : 0) != 0);
                return offset / 4;
            }
            offset += element.m_86050_();
        }
        throw new IllegalStateException();
    }

    private static int findTextureOffset() {
        return ITRenderUtils.findOffset(VertexFormatElement.Usage.UV);
    }

    private static int findPositionOffset() {
        return ITRenderUtils.findOffset(VertexFormatElement.Usage.POSITION);
    }

    static {
        for (int i = 0; i < quadCoords.length; ++i) {
            ITRenderUtils.quadCoords[i] = new Vector4f();
        }
    }
}

