/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mctmods.immersivetechnology.common.util.ITFakePlayerUtil;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class ITQueueProcessor {
    private final Level level;
    private final List<AbstractMap.SimpleEntry<BlockPos, BlockState>> queue = new ArrayList<AbstractMap.SimpleEntry<BlockPos, BlockState>>();
    private final List<BlockPos> pendingBreaks = new ArrayList<BlockPos>();
    @Nullable
    private final ServerPlayer owner;
    private FakePlayer fakePlayer;
    private final Set<ChunkPos> affectedChunks = new HashSet<ChunkPos>();
    private boolean chunksMarked = false;

    public ITQueueProcessor(Level level, List<AbstractMap.SimpleEntry<BlockPos, BlockState>> sourceQueue, @Nullable ServerPlayer owner) {
        this.level = level;
        this.owner = owner;
        this.queue.addAll(sourceQueue);
        this.queue.sort(Comparator.comparingInt(e -> -((BlockPos)e.getKey()).m_123342_()));
        for (AbstractMap.SimpleEntry<BlockPos, BlockState> entry : sourceQueue) {
            ChunkPos cp = new ChunkPos(entry.getKey());
            for (int dx = -4; dx <= 4; ++dx) {
                for (int dz = -4; dz <= 4; ++dz) {
                    this.affectedChunks.add(new ChunkPos(cp.f_45578_ + dx, cp.f_45579_ + dz));
                }
            }
        }
    }

    public void tick() {
        int i;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.chunksMarked) {
            for (ChunkPos chunk : this.affectedChunks) {
                LevelChunk levelChunk = serverLevel.m_6325_(chunk.f_45578_, chunk.f_45579_);
                levelChunk.m_8094_(false);
                levelChunk.m_8092_(true);
            }
            this.chunksMarked = true;
        }
        if (this.queue.isEmpty() && this.pendingBreaks.isEmpty()) {
            if (this.fakePlayer != null) {
                ChunkMap chunkMap = serverLevel.m_7726_().f_8325_;
                ThreadedLevelLightEngine lightEngine = serverLevel.m_7726_().m_7827_();
                for (ChunkPos chunk : this.affectedChunks) {
                    LevelChunk levelChunk = serverLevel.m_6325_(chunk.f_45578_, chunk.f_45579_);
                    levelChunk.m_8094_(false);
                    levelChunk.m_8092_(true);
                    List players = chunkMap.m_183262_(chunk, false);
                    players.forEach(p -> p.f_8906_.m_9829_((Packet)new ClientboundForgetLevelChunkPacket(chunk.f_45578_, chunk.f_45579_)));
                    ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(levelChunk, (LevelLightEngine)lightEngine, null, null);
                    players.forEach(p -> p.f_8906_.m_9829_((Packet)packet));
                    ChunkHolder holder = chunkMap.m_140174_(chunk.m_45588_());
                    if (holder == null) continue;
                    holder.m_140054_(levelChunk);
                }
                this.affectedChunks.clear();
                this.fakePlayer = null;
            }
            return;
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = ITFakePlayerUtil.getFakePlayer(serverLevel, this.owner);
        }
        int blocksPerTick = 8;
        for (i = 0; i < blocksPerTick && !this.pendingBreaks.isEmpty(); ++i) {
            BlockPos pos = this.pendingBreaks.remove(0);
            this.fakePlayer.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
            this.fakePlayer.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)pos));
            this.fakePlayer.f_8941_.m_9280_(pos);
        }
        for (i = 0; i < blocksPerTick && !this.queue.isEmpty(); ++i) {
            AbstractMap.SimpleEntry<BlockPos, BlockState> entry = this.queue.remove(0);
            BlockPos pos = entry.getKey();
            BlockState template = entry.getValue();
            this.level.m_7731_(pos, template, 3);
            this.pendingBreaks.add(pos);
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() && this.pendingBreaks.isEmpty();
    }
}

