/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.stone.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.stone.process.CoolingTowerProcess;
import mctmods.immersivetechnology.common.multiblocks.stone.recipe.CoolingTowerRecipe;
import mctmods.immersivetechnology.common.multiblocks.stone.shapes.CoolingTowerShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITParticles;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CoolingTowerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
ITPressurizedFluidOutput<State> {
    public static final int INPUT_TANK_CAPACITY = 24000;
    public static final int OUTPUT_TANK_CAPACITY = 24000;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])CoolingTowerShape.DATA.pointsOfInterest);
    public static final List<BlockPos> FLUID_INPUT_POIS = CoolingTowerLogic.getPosList("fluid_input");
    public static final List<BlockPos> FLUID_OUTPUT_POIS = CoolingTowerLogic.getPosList("fluid_output");
    public static final BlockPos PARTICLE_POS = CoolingTowerLogic.getPosList("particle").get(0);
    public static final BlockPos SOUND_POS = CoolingTowerLogic.getPosList("sound").get(0);
    private static final RelativeBlockFace INPUT_FACING = CoolingTowerLogic.getFacing("fluid_input");
    private static final RelativeBlockFace OUTPUT_FACING = CoolingTowerLogic.getFacing("fluid_output");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return FLUID_OUTPUT_POIS;
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return ctx.getLevel().toAbsolute(OUTPUT_FACING);
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return ImmutableList.of((Object)((Object)state.tanks.output0), (Object)((Object)state.tanks.output1), (Object)((Object)state.tanks.output2));
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return ImmutableList.of(state.fluidOutputs[0], state.fluidOutputs[1], state.fluidOutputs[2]);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        if (state.active) {
            state.soundCooldown = 40;
        } else if (state.soundCooldown > 0) {
            --state.soundCooldown;
        }
        this.spawnParticles(ctx, state, ctx.getLevel().getRawLevel());
        this.handleSounds(ctx, state);
    }

    private void spawnParticles(IMultiblockContext<State> ctx, State state, Level level) {
        if (!state.active) {
            return;
        }
        RandomSource rand = RandomSource.m_216327_();
        int particleSetting = ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).ordinal();
        if (particleSetting == 2 || particleSetting == 1 && rand.m_188503_(3) == 0) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 particleVec = ctx.getLevel().toAbsolute(new Vec3((double)PARTICLE_POS.m_123341_() + 0.5, (double)PARTICLE_POS.m_123342_() + 0.5, (double)PARTICLE_POS.m_123343_() + 0.5));
        assert (player != null);
        if (particleVec.m_82557_(player.m_20182_()) > 4096.0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            double px = particleVec.f_82479_ + (double)(rand.m_188501_() * 4.0f - 2.0f);
            double py = particleVec.f_82480_ + (double)(rand.m_188501_() * 2.0f);
            double pz = particleVec.f_82481_ + (double)(rand.m_188501_() * 4.0f - 2.0f);
            level.m_7106_((ParticleOptions)ITParticles.SMOKE_CUSTOM.get(), px, py, pz, ((double)rand.m_188501_() - 0.5) * 0.02, 0.01 + (double)rand.m_188501_() * 0.02, ((double)rand.m_188501_() - 0.5) * 0.02);
        }
    }

    private void handleSounds(IMultiblockContext<State> ctx, State state) {
        if (state.isSoundPlaying.getAsBoolean()) {
            return;
        }
        Vec3 soundVec = ctx.getLevel().toAbsolute(new Vec3((double)SOUND_POS.m_123341_() + 0.5, (double)SOUND_POS.m_123342_() + 0.5, (double)SOUND_POS.m_123343_() + 0.5));
        state.isSoundPlaying = ITSound.startSound(() -> state.soundCooldown > 0, ctx.isValid(), soundVec, ITSounds.coolingTower, () -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((float)Math.max(1.0 - Math.sqrt(player.m_20238_(soundVec)) / 16.0, 0.0));
        }, () -> Float.valueOf(1.0f));
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean update;
        this.pumpOutputs(ctx);
        State state = (State)ctx.getState();
        IMultiblockLevel mlevel = ctx.getLevel();
        Level level = mlevel.getRawLevel();
        boolean wasActive = state.active;
        for (int i = state.processQueue.size() - 1; i >= 0; --i) {
            CoolingTowerProcess process = state.processQueue.get(i);
            process.tick(state);
            if (!process.isComplete()) continue;
            state.processQueue.remove(i);
        }
        if (state.processQueue.size() < this.getProcessQueueMaxLength()) {
            FluidStack in0 = state.tanks.input0.getFluid();
            FluidStack in1 = state.tanks.input1.getFluid();
            CoolingTowerRecipe recipe = CoolingTowerRecipe.findRecipe(level, in0, in1);
            boolean swapped = false;
            if (recipe == null) {
                recipe = CoolingTowerRecipe.findRecipe(level, in1, in0);
                swapped = true;
            }
            if (recipe != null) {
                FluidStack secondIn;
                FluidStack firstIn = swapped ? in1 : in0;
                FluidStack fluidStack = secondIn = swapped ? in0 : in1;
                if (firstIn.getAmount() >= recipe.input0.getAmount() && secondIn.getAmount() >= recipe.input1.getAmount()) {
                    boolean canOutput = true;
                    if (!recipe.fluidOutput0.isEmpty()) {
                        canOutput &= state.tanks.output0.fill(recipe.fluidOutput0, IFluidHandler.FluidAction.SIMULATE) >= recipe.fluidOutput0.getAmount();
                    }
                    if (!recipe.fluidOutput1.isEmpty()) {
                        canOutput &= state.tanks.output1.fill(recipe.fluidOutput1, IFluidHandler.FluidAction.SIMULATE) >= recipe.fluidOutput1.getAmount();
                    }
                    if (!recipe.fluidOutput2.isEmpty()) {
                        canOutput &= state.tanks.output2.fill(recipe.fluidOutput2, IFluidHandler.FluidAction.SIMULATE) >= recipe.fluidOutput2.getAmount();
                    }
                    if (canOutput) {
                        CoolingTowerRecipe useRecipe = swapped ? new CoolingTowerRecipe(recipe.m_6423_(), recipe.fluidOutput0, recipe.fluidOutput1, recipe.fluidOutput2, recipe.input1, recipe.input0, recipe.totalProcessTime) : recipe;
                        state.processQueue.add(new CoolingTowerProcess(useRecipe));
                    }
                }
            }
        }
        state.active = !state.processQueue.isEmpty();
        boolean bl = update = wasActive != state.active;
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private int getProcessQueueMaxLength() {
        return 3;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            int index;
            BlockPos localPos = position.posInMultiblock();
            RelativeBlockFace side = position.side();
            if (FLUID_INPUT_POIS.contains(localPos) && (side == null || side == INPUT_FACING)) {
                index = FLUID_INPUT_POIS.indexOf(localPos);
                if (index == 0) {
                    return state.input0Cap.cast(ctx);
                }
                if (index == 1) {
                    return state.input1Cap.cast(ctx);
                }
            }
            if (FLUID_OUTPUT_POIS.contains(localPos) && (side == null || side == OUTPUT_FACING)) {
                index = FLUID_OUTPUT_POIS.indexOf(localPos);
                if (index == 0) {
                    return state.output0Cap.cast(ctx);
                }
                if (index == 1) {
                    return state.output1Cap.cast(ctx);
                }
                if (index == 2) {
                    return state.output2Cap.cast(ctx);
                }
            }
        }
        return LazyOptional.empty();
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return CoolingTowerShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final CoolingTowerTanks tanks;
        public final StoredCapability<IFluidHandler> input0Cap;
        public final StoredCapability<IFluidHandler> input1Cap;
        public final StoredCapability<IFluidHandler> output0Cap;
        public final StoredCapability<IFluidHandler> output1Cap;
        public final StoredCapability<IFluidHandler> output2Cap;
        public final CapabilityReference<IFluidHandler>[] fluidOutputs = new CapabilityReference[3];
        public boolean active;
        public int soundCooldown = 0;
        public List<CoolingTowerProcess> processQueue = new ArrayList<CoolingTowerProcess>();
        public BooleanSupplier isSoundPlaying = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Consumer<Void> onChanged = v -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new CoolingTowerTanks(onChanged);
            this.input0Cap = new StoredCapability((Object)ITArrayFluidHandler.fillOnly((IFluidTank)this.tanks.input0, () -> onChanged.accept(null)));
            this.input1Cap = new StoredCapability((Object)ITArrayFluidHandler.fillOnly((IFluidTank)this.tanks.input1, () -> onChanged.accept(null)));
            this.output0Cap = new StoredCapability((Object)ITArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output0, () -> onChanged.accept(null)));
            this.output1Cap = new StoredCapability((Object)ITArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output1, () -> onChanged.accept(null)));
            this.output2Cap = new StoredCapability((Object)ITArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output2, () -> onChanged.accept(null)));
            BlockPos[] outputPositions = FLUID_OUTPUT_POIS.toArray(new BlockPos[0]);
            for (int i = 0; i < 3; ++i) {
                MultiblockFace mbf = new MultiblockFace(OUTPUT_FACING, outputPositions[i]);
                CapabilityPosition oppCp = CapabilityPosition.opposing((MultiblockFace)mbf);
                MultiblockFace oppMbf = new MultiblockFace(oppCp.side(), oppCp.posInMultiblock());
                this.fluidOutputs[i] = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, oppMbf);
            }
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128379_("active", this.active);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.active = nbt.m_128471_("active");
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tanks.input0, this.tanks.input1, this.tanks.output0, this.tanks.output1, this.tanks.output2};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
        }
    }

    public record CoolingTowerTanks(ITMarkableFluidTank input0, ITMarkableFluidTank input1, ITMarkableFluidTank output0, ITMarkableFluidTank output1, ITMarkableFluidTank output2) {
        public CoolingTowerTanks(Consumer<Void> markDirty) {
            this(new ITMarkableFluidTank(24000, markDirty), new ITMarkableFluidTank(24000, markDirty), new ITMarkableFluidTank(24000, markDirty), new ITMarkableFluidTank(24000, markDirty), new ITMarkableFluidTank(24000, markDirty));
        }

        public static CoolingTowerTanks makeClient() {
            return new CoolingTowerTanks(v -> {});
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("input0", (Tag)this.input0.writeToNBT(new CompoundTag()));
            tag.m_128365_("input1", (Tag)this.input1.writeToNBT(new CompoundTag()));
            tag.m_128365_("output0", (Tag)this.output0.writeToNBT(new CompoundTag()));
            tag.m_128365_("output1", (Tag)this.output1.writeToNBT(new CompoundTag()));
            tag.m_128365_("output2", (Tag)this.output2.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.input0.readFromNBT(tag.m_128469_("input0"));
            this.input1.readFromNBT(tag.m_128469_("input1"));
            this.output0.readFromNBT(tag.m_128469_("output0"));
            this.output1.readFromNBT(tag.m_128469_("output1"));
            this.output2.readFromNBT(tag.m_128469_("output2"));
        }
    }
}

