/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.renderer.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class ITRenderTypes
extends RenderStateShard {
    public static final RenderType TRANSLUCENT_POSITION_COLOR;
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY;
    protected static final RenderStateShard.TextureStateShard BLOCK_SHEET_MIPPED;
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_POSITION_COLOR;
    protected static final RenderStateShard.ShaderStateShard POSITION_COLOR_TEX_SHADER;
    private static final Function<ResourceLocation, RenderType> GUI_CUTOUT;
    private static final Function<ResourceLocation, RenderType> GUI_TRANSLUCENT;

    private ITRenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    private static RenderType createDefault(String name, VertexFormat format, RenderType.CompositeState state) {
        return RenderType.m_173215_((String)name, (VertexFormat)format, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    private static RenderType.CompositeState.CompositeStateBuilder makeGuiState(ResourceLocation texture) {
        return RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(POSITION_COLOR_TEX_SHADER);
    }

    public static RenderType getGui(ResourceLocation texture) {
        return GUI_CUTOUT.apply(texture);
    }

    public static RenderType getGuiTranslucent(ResourceLocation texture) {
        return GUI_TRANSLUCENT.apply(texture);
    }

    static {
        TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }, RenderSystem::disableBlend);
        BLOCK_SHEET_MIPPED = new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, true);
        RENDERTYPE_POSITION_COLOR = f_173091_;
        POSITION_COLOR_TEX_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_);
        GUI_CUTOUT = Util.m_143827_(texture -> ITRenderTypes.createDefault("gui_" + String.valueOf(texture), DefaultVertexFormat.f_85818_, ITRenderTypes.makeGuiState(texture).m_110691_(false)));
        GUI_TRANSLUCENT = Util.m_143827_(texture -> ITRenderTypes.createDefault("gui_translucent_" + String.valueOf(texture), DefaultVertexFormat.f_85818_, ITRenderTypes.makeGuiState(texture).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110691_(false)));
        RenderType.CompositeState translucentNoTextureState = RenderType.CompositeState.m_110628_().m_110685_(TRANSLUCENT_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).m_173292_(RENDERTYPE_POSITION_COLOR).m_110691_(false);
        TRANSLUCENT_POSITION_COLOR = ITRenderTypes.createDefault("immersivetechnology:translucent_pos_color", DefaultVertexFormat.f_85815_, translucentNoTextureState);
    }
}

