/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Consumer;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.metal.logic.OSDCommonBlockEntity;
import mctmods.immersivetechnology.common.network.ITOSDRequestMessage;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.ITClientConfig;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelCreativeBlockEntity
extends OSDCommonBlockEntity
implements ITBlockInterfaces.IBlockEntityDrop,
ITBlockInterfaces.IPlayerInteraction,
ITBlockInterfaces.IBlockOverlayText {
    private FluidStack selectedFluid = FluidStack.EMPTY;
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            if (BarrelCreativeBlockEntity.this.selectedFluid.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(BarrelCreativeBlockEntity.this.selectedFluid, Integer.MAX_VALUE);
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BarrelCreativeBlockEntity.this.selectedFluid.isEmpty() || !BarrelCreativeBlockEntity.this.selectedFluid.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(BarrelCreativeBlockEntity.this.selectedFluid, resource.getAmount());
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (BarrelCreativeBlockEntity.this.selectedFluid.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(BarrelCreativeBlockEntity.this.selectedFluid, maxDrain);
        }
    });

    public BarrelCreativeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.BARREL_CREATIVE.get(), pos, state);
    }

    @Override
    public void tickServer() {
        if (!this.selectedFluid.isEmpty()) {
            long thisTickOutput = 0L;
            for (Direction dir : Direction.values()) {
                LazyOptional cap;
                boolean hadTag;
                BlockPos neighborPos = this.f_58858_.m_121945_(dir);
                assert (this.f_58857_ != null);
                BlockEntity neighbor = this.f_58857_.m_7702_(neighborPos);
                boolean isPipe = neighbor instanceof FluidPipeBlockEntity;
                FluidStack fs = this.selectedFluid.copy();
                fs.setAmount(Integer.MAX_VALUE);
                boolean bl = hadTag = fs.hasTag() && fs.getTag().m_128441_("pressurized");
                if (isPipe && !hadTag) {
                    fs.getOrCreateTag().m_128379_("pressurized", true);
                }
                if (!(cap = FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)neighborPos, (Direction)dir.m_122424_())).isPresent()) continue;
                IFluidHandler handler = (IFluidHandler)cap.orElseThrow(AssertionError::new);
                int accepted = handler.fill(fs, IFluidHandler.FluidAction.SIMULATE);
                if (!hadTag) {
                    fs.removeChildTag("pressurized");
                }
                if (accepted <= 0) continue;
                FluidStack toFill = Utils.copyFluidStackWithAmount((FluidStack)fs, (int)accepted, (boolean)false);
                if (isPipe) {
                    toFill.getOrCreateTag().m_128379_("pressurized", true);
                }
                int filled = handler.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
                thisTickOutput += (long)filled;
            }
            this.acceptedAmount += thisTickOutput;
        }
        super.tickServer();
    }

    @Override
    public void readCustomNBT(@NotNull CompoundTag nbt, boolean descPacket) {
        if (nbt.m_128441_("SelectedFluid")) {
            this.selectedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("SelectedFluid"));
            if (this.selectedFluid == null) {
                this.selectedFluid = FluidStack.EMPTY;
            }
        }
    }

    @Override
    public void writeCustomNBT(@NotNull CompoundTag nbt, boolean descPacket) {
        if (!this.selectedFluid.isEmpty()) {
            nbt.m_128365_("SelectedFluid", (Tag)this.selectedFluid.writeToNBT(new CompoundTag()));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean interact(@NotNull Direction side, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY);
        if (!contained.isEmpty()) {
            this.setOutputFluid(contained);
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                SoundEvent sound = contained.getFluid().getFluidType().getSound(player, (BlockGetter)this.f_58857_, this.f_58858_, SoundActions.BUCKET_EMPTY);
                if (sound == null) {
                    sound = ForgeRegistries.FLUIDS.getHolder((Object)contained.getFluid()).map(holder -> holder.m_203656_(FluidTags.f_13132_)).orElse(false) != false ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
                }
                this.f_58857_.m_5594_(null, this.f_58858_, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (player.m_6144_()) {
            this.setOutputFluid(FluidStack.EMPTY);
            return true;
        }
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((IFluidHandler)this.fluidHandler.orElseThrow(RuntimeException::new)));
    }

    @Override
    public TranslationKey text() {
        return TranslationKey.OVERLAY_OSD_BARREL_NORMAL_FIRST_LINE;
    }

    @Override
    public Component[] getOverlayText(@NotNull Player player, @NotNull HitResult rtr, boolean hammer) {
        if (rtr.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ && this.requestCooldown == 0) {
            ITPacketHandler.sendToServer(new ITOSDRequestMessage(this.f_58858_));
            this.requestCooldown = 20;
        }
        if (this.selectedFluid.isEmpty()) {
            return new Component[]{Component.m_237115_((String)TranslationKey.GUI_EMPTY.text())};
        }
        Component fluidName = this.selectedFluid.getDisplayName();
        float value = ITClientConfig.perTickTrashCans ? (float)this.lastAcceptedAmount / 20.0f : (float)this.lastAcceptedAmount;
        return new Component[]{Component.m_237110_((String)this.text().text(), (Object[])new Object[]{fluidName, Float.valueOf(value)})};
    }

    @Override
    public void getBlockEntityDrop(@NotNull LootContext context, @NotNull Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        this.onBEPlaced(ctx.m_43722_());
    }

    public void setOutputFluid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            this.selectedFluid = FluidStack.EMPTY;
        } else {
            this.selectedFluid = fluidStack.copy();
            this.selectedFluid.setAmount(1);
        }
        this.m_6596_();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.selectedFluid.isEmpty()) {
            tag.m_128365_("SelectedFluid", (Tag)this.selectedFluid.writeToNBT(new CompoundTag()));
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("SelectedFluid")) {
            this.selectedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("SelectedFluid"));
            if (this.selectedFluid == null) {
                this.selectedFluid = FluidStack.EMPTY;
            }
        }
    }

    public void onBEPlaced(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            assert (tag != null);
            if (tag.m_128441_("SelectedFluid")) {
                this.selectedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("SelectedFluid"));
                if (this.selectedFluid == null) {
                    this.selectedFluid = FluidStack.EMPTY;
                }
            }
        }
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
    }
}

