/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jade;

import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.AlternatorLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerLiquidLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerSolidLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerTankLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.DistillerLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.GasTurbineLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarMelterLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarReflectorLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarTowerLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SteamTurbineLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SteelSheetmetalTankLogic;
import mctmods.immersivetechnology.common.multiblocks.stone.logic.CoolingTowerLogic;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public enum ITStatusDataProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return ITLib.rl("status");
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof IMultiblockBE) {
            IMultiblockBE mbe = (IMultiblockBE)blockEntity;
            IMultiblockState state = mbe.getHelper().getState();
            if (state == null) {
                return;
            }
            boolean active = false;
            boolean fuelEmpty = false;
            if (state instanceof DistillerLogic.State) {
                DistillerLogic.State distiller = (DistillerLogic.State)state;
                active = distiller.isActive();
            } else if (state instanceof BoilerLiquidLogic.State) {
                BoilerLiquidLogic.State boiler = (BoilerLiquidLogic.State)state;
                active = boiler.active;
                fuelEmpty = boiler.tanks.input1().getFluid().isEmpty();
            } else if (state instanceof AlternatorLogic.State) {
                AlternatorLogic.State alternator = (AlternatorLogic.State)state;
                active = alternator.speed > 0;
            } else if (state instanceof BoilerSolidLogic.State) {
                BoilerSolidLogic.State boilerSolid = (BoilerSolidLogic.State)state;
                active = boilerSolid.active;
                fuelEmpty = boilerSolid.inventory.getStackInSlot(0).m_41619_();
            } else if (state instanceof BoilerTankLogic.State) {
                BoilerTankLogic.State boilerTank = (BoilerTankLogic.State)state;
                active = boilerTank.active;
            } else if (state instanceof CoolingTowerLogic.State) {
                CoolingTowerLogic.State coolingTower = (CoolingTowerLogic.State)state;
                active = coolingTower.active;
            } else if (state instanceof GasTurbineLogic.State) {
                GasTurbineLogic.State gas = (GasTurbineLogic.State)state;
                active = gas.active;
                fuelEmpty = gas.tanks.input().getFluid().isEmpty();
            } else if (state instanceof SolarMelterLogic.State) {
                SolarMelterLogic.State melter = (SolarMelterLogic.State)state;
                active = melter.active;
                fuelEmpty = melter.tanks.input().getFluid().isEmpty();
            } else if (state instanceof SolarReflectorLogic.State) {
                SolarReflectorLogic.State reflector = (SolarReflectorLogic.State)state;
                active = reflector.active;
            } else if (state instanceof SolarTowerLogic.State) {
                SolarTowerLogic.State tower = (SolarTowerLogic.State)state;
                active = tower.active;
                fuelEmpty = tower.tanks.input().getFluid().isEmpty();
            } else if (state instanceof SteamTurbineLogic.State) {
                SteamTurbineLogic.State steam = (SteamTurbineLogic.State)state;
                active = steam.active;
                fuelEmpty = steam.tanks.input().getFluid().isEmpty();
            } else if (state instanceof SteelSheetmetalTankLogic.State) {
                SteelSheetmetalTankLogic.State tank = (SteelSheetmetalTankLogic.State)state;
                active = tank.active;
            }
            data.m_128379_("ITActive", active);
            if (fuelEmpty) {
                data.m_128379_("ITFuelEmpty", true);
            }
        }
    }
}

