/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.network;

import java.util.function.Supplier;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.network.ITMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ITMessageTileSync
implements ITMessage {
    private final BlockPos pos;
    private final CompoundTag nbt;

    public ITMessageTileSync(BlockPos pos, CompoundTag nbt) {
        this.pos = pos;
        this.nbt = nbt;
    }

    public ITMessageTileSync(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.nbt = buf.m_130260_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.nbt);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            ctx.enqueueWork(() -> {
                Level level = player.m_9236_();
                BlockEntity tile = level.m_7702_(this.pos);
                if (tile instanceof ValveCommonBlockEntity) {
                    ValveCommonBlockEntity valve = (ValveCommonBlockEntity)tile;
                    valve.receiveMessageFromClient(this.nbt);
                }
            });
        }
    }
}

