/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.helper;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.client.models.helper.ITBakedModel;
import mctmods.immersivetechnology.client.models.util.ITModelUtils;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITEnums;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ITModelConfigurableSides
extends ITBakedModel {
    private static final HashMap<String, ITextureNamer> TYPES = new HashMap();
    private final LoadingCache<Map<Direction, ITEnums.IOSideConfig>, Map<Direction, BakedQuad>> modelCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        EnumMap<Direction, TextureAtlasSprite> tex = new EnumMap<Direction, TextureAtlasSprite>(Direction.class);
        for (Direction d : DirectionUtils.VALUES) {
            assert (key != null);
            tex.put(d, this.textures.get(d).get(key.get(d)));
        }
        return ITModelConfigurableSides.bakeQuads(tex);
    }));
    final String name;
    public Map<Direction, Map<ITEnums.IOSideConfig, TextureAtlasSprite>> textures;
    private final RenderTypeGroup renderTypes;
    static final ItemTransforms defaultTransforms;

    public ITModelConfigurableSides(String name, Map<Direction, Map<ITEnums.IOSideConfig, TextureAtlasSprite>> textures, RenderTypeGroup renderTypes) {
        this.name = name;
        this.textures = textures;
        this.renderTypes = renderTypes;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        EnumMap<Direction, ITEnums.IOSideConfig> config;
        if (side == null) {
            return ImmutableList.of();
        }
        if (extraData.has(ITProperties.Model.SIDECONFIG)) {
            config = (EnumMap<Direction, ITEnums.IOSideConfig>)extraData.get(ITProperties.Model.SIDECONFIG);
        } else {
            config = new EnumMap<Direction, ITEnums.IOSideConfig>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                config.put(d, ITEnums.IOSideConfig.NONE);
            }
        }
        assert (config != null);
        return ImmutableList.of((Object)((BakedQuad)((Map)this.modelCache.getUnchecked(config)).get(side)));
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData.Builder data = super.getModelData(world, pos, state, tileData).derive();
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITBlockInterfaces.IConfigurableSides) {
            ITBlockInterfaces.IConfigurableSides confBE = (ITBlockInterfaces.IConfigurableSides)te;
            EnumMap<Direction, ITEnums.IOSideConfig> conf = new EnumMap<Direction, ITEnums.IOSideConfig>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                conf.put(d, confBE.getSideConfig(d));
            }
            data.with(ITProperties.Model.SIDECONFIG, conf);
        }
        return data.build();
    }

    private static Map<Direction, BakedQuad> bakeQuads(Map<Direction, TextureAtlasSprite> sprites) {
        EnumMap<Direction, BakedQuad> quads = new EnumMap<Direction, BakedQuad>(Direction.class);
        Vec3[] vertices = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, 0.0)};
        ITModelConfigurableSides.addQuad(quads, sprites, Direction.DOWN, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 0.0)};
        ITModelConfigurableSides.addQuad(quads, sprites, Direction.UP, vertices, new double[]{0.0, 0.0, 16.0, 16.0});
        vertices = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        ITModelConfigurableSides.addQuad(quads, sprites, Direction.NORTH, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vec3[]{new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0)};
        ITModelConfigurableSides.addQuad(quads, sprites, Direction.SOUTH, vertices, new double[]{16.0, 16.0, 0.0, 0.0});
        vertices = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0)};
        ITModelConfigurableSides.addQuad(quads, sprites, Direction.WEST, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 0.0, 1.0)};
        ITModelConfigurableSides.addQuad(quads, sprites, Direction.EAST, vertices, new double[]{16.0, 16.0, 0.0, 0.0});
        return quads;
    }

    private static void addQuad(Map<Direction, BakedQuad> out, Map<Direction, TextureAtlasSprite> sprites, Direction side, Vec3[] vertices, double[] uv) {
        out.put(side, ITModelUtils.createBakedQuad(vertices, side, sprites.get(side), uv, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, side.m_122421_() == Direction.AxisDirection.NEGATIVE));
    }

    @Override
    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.textures.get(Direction.DOWN).get((Object)ITEnums.IOSideConfig.NONE);
    }

    @Override
    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.renderTypes.block()});
    }

    @NotNull
    public List<RenderType> getRenderTypes(@NotNull ItemStack itemStack, boolean fabulous) {
        return List.of(fabulous ? this.renderTypes.entityFabulous() : this.renderTypes.entity());
    }

    @NotNull
    public BakedModel applyTransform(@NotNull ItemDisplayContext transformType, @NotNull PoseStack poseStack, boolean applyLeftHandTransform) {
        defaultTransforms.m_269404_(transformType).m_111763_(applyLeftHandTransform, poseStack);
        return this;
    }

    static {
        for (Type type : Type.values()) {
            TYPES.put(type.getName(), type.nameMapper);
        }
        defaultTransforms = new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.25f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), ImmutableMap.of());
    }

    public static enum Type {
        SIDE_TOP_BOTTOM(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, ITEnums.IOSideConfig cfg) {
                return side.m_122434_() == Direction.Axis.Y ? side.m_7912_() : "side";
            }
        }),
        SIDE_VERTICAL(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, ITEnums.IOSideConfig cfg) {
                return side.m_122434_() == Direction.Axis.Y ? "up" : "side";
            }
        }),
        VERTICAL(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, ITEnums.IOSideConfig cfg) {
                return side.m_122434_() == Direction.Axis.Y ? "up" : "side";
            }

            @Override
            public String nameFromCfg(Direction side, ITEnums.IOSideConfig cfg) {
                return side.m_122434_() == Direction.Axis.Y ? cfg.getTextureName() : null;
            }
        }),
        ALL_SAME_TEXTURE(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, ITEnums.IOSideConfig cfg) {
                return "side";
            }
        });

        private final ITextureNamer nameMapper;

        private Type(ITextureNamer nameMapper) {
            this.nameMapper = nameMapper;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static interface ITextureNamer {
        default public String getTextureName(Direction side, ITEnums.IOSideConfig cfg) {
            String s = this.nameFromSide(side, cfg);
            String c = this.nameFromCfg(side, cfg);
            if (s != null && c != null) {
                return s + "_" + c;
            }
            return Objects.requireNonNullElseGet(s, () -> c != null ? c : "");
        }

        default public String nameFromSide(Direction side, ITEnums.IOSideConfig cfg) {
            return side.m_7912_();
        }

        default public String nameFromCfg(Direction side, ITEnums.IOSideConfig cfg) {
            return cfg.getTextureName();
        }
    }

    public record ConfigSidesModelBase(String name, String type, Map<String, Material> textures) implements IUnbakedGeometry<ConfigSidesModelBase>
    {
        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            EnumMap<Direction, Map<ITEnums.IOSideConfig, TextureAtlasSprite>> tex = new EnumMap<Direction, Map<ITEnums.IOSideConfig, TextureAtlasSprite>>(Direction.class);
            for (Direction f : DirectionUtils.VALUES) {
                EnumMap<ITEnums.IOSideConfig, TextureAtlasSprite> forSide = new EnumMap<ITEnums.IOSideConfig, TextureAtlasSprite>(ITEnums.IOSideConfig.class);
                for (ITEnums.IOSideConfig cfg : ITEnums.IOSideConfig.values()) {
                    Material rl = this.textures.get(f.m_7912_() + "_" + cfg.getTextureName());
                    if (rl == null) continue;
                    forSide.put(cfg, spriteGetter.apply(rl));
                }
                tex.put(f, forSide);
            }
            ResourceLocation renderTypeName = Objects.requireNonNullElseGet(owner.getRenderTypeHint(), () -> ResourceLocation.withDefaultNamespace((String)"solid"));
            return new ITModelConfigurableSides(this.name, tex, owner.getRenderType(renderTypeName));
        }
    }

    public static class Loader
    implements IGeometryLoader<ConfigSidesModelBase> {
        public static ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"conf_sides");

        @Nonnull
        public ConfigSidesModelBase read(JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
            String name = modelContents.get("base_name").getAsString();
            String type = modelContents.get("type").getAsString();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ITextureNamer namer = TYPES.get(type);
            for (Direction f : DirectionUtils.VALUES) {
                for (ITEnums.IOSideConfig cfg : ITEnums.IOSideConfig.values()) {
                    String key = f.m_7912_() + "_" + cfg.getTextureName();
                    String tex = name + "_" + namer.getTextureName(f, cfg);
                    builder.put((Object)key, (Object)new Material(InventoryMenu.f_39692_, ResourceLocation.parse((String)tex)));
                }
            }
            return new ConfigSidesModelBase(name, type, (Map<String, Material>)builder.build());
        }
    }
}

