/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.particles;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ColoredBeam {
    private static final RenderStateShard.ShaderStateShard BEACON_BEAM_SHADER = RenderStateShard.f_173068_;
    private static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = RenderStateShard.f_110139_;
    private static final RenderStateShard.TransparencyStateShard NO_TRANSPARENCY = RenderStateShard.f_110134_;
    private static final RenderStateShard.WriteMaskStateShard COLOR_WRITE = RenderStateShard.f_110115_;
    private static final RenderStateShard.WriteMaskStateShard COLOR_DEPTH_WRITE = RenderStateShard.f_110114_;
    private static final RenderStateShard.CullStateShard NO_CULL = RenderStateShard.f_110110_;

    public static void renderBeam(PoseStack matrixStack, MultiBufferSource buffer, ResourceLocation texture, float partialTicks, float textureScale, long time, boolean upward, float innerBottomG, float innerTopG, float innerA, float outerBottomG, float outerTopG, float outerA, float yBottom, float yTop, double worldX, double worldYBottom, double worldYTop, double worldZ) {
        double clippedWorldTop;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 camPos = camera.m_90583_();
        double dx = worldX - camPos.f_82479_;
        double dz = worldZ - camPos.f_82481_;
        double dhorSq = dx * dx + dz * dz;
        if (dhorSq >= 10000.0) {
            return;
        }
        double delta = Math.sqrt(10000.0 - dhorSq);
        double yLow = camPos.f_82480_ - delta;
        double yHigh = camPos.f_82480_ + delta;
        double clippedWorldBottom = Math.max(worldYBottom, yLow);
        if (clippedWorldBottom >= (clippedWorldTop = Math.min(worldYTop, yHigh))) {
            return;
        }
        float deltaBottom = (float)(clippedWorldBottom - worldYBottom);
        float deltaTop = (float)(clippedWorldTop - worldYTop);
        float renderYBottom = yBottom + deltaBottom;
        float renderYTop = yTop + deltaTop;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        float spin = (float)Math.floorMod(time, 40L) + partialTicks;
        float offset = upward ? -spin : spin;
        float frac = Mth.m_14187_((float)(offset * 0.2f - (float)Mth.m_14143_((float)(offset * 0.1f))));
        float vMin = -1.0f + frac;
        float vMax = (yTop - yBottom) * textureScale + vMin;
        float renderVMin = vMin + deltaBottom * textureScale;
        float renderVMax = vMax + deltaTop * textureScale;
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(spin * (upward ? 2.25f : -2.25f) - 45.0f));
        float x0 = 0.0f;
        float z0 = 0.2f;
        float x1 = 0.2f;
        float z1 = 0.0f;
        float x2 = -0.2f;
        float z2 = 0.0f;
        float x3 = 0.0f;
        float z3 = -0.2f;
        float uMin = 0.0f;
        float uMax = 1.0f;
        ColoredBeam.renderPart(matrixStack, buffer.m_6299_(ColoredBeam.getBeamRenderType(texture, false)), innerTopG, innerBottomG, innerA, x0, z0, x1, z1, x2, z2, x3, z3, uMin, uMax, renderVMax, renderVMin, renderYTop, renderYBottom);
        matrixStack.m_85849_();
        x0 = -0.25f;
        z0 = -0.25f;
        x1 = 0.25f;
        z1 = -0.25f;
        x2 = 0.25f;
        z2 = 0.25f;
        x3 = -0.25f;
        z3 = 0.25f;
        ColoredBeam.renderPart(matrixStack, buffer.m_6299_(ColoredBeam.getBeamRenderType(texture, true)), outerTopG, outerBottomG, outerA, x0, z0, x1, z1, x2, z2, x3, z3, uMin, uMax, renderVMax, renderVMin, renderYTop, renderYBottom);
        matrixStack.m_85849_();
    }

    private static RenderType getBeamRenderType(ResourceLocation texture, boolean translucent) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(BEACON_BEAM_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(translucent ? TRANSLUCENT_TRANSPARENCY : NO_TRANSPARENCY).m_110687_(translucent ? COLOR_WRITE : COLOR_DEPTH_WRITE).m_110661_(NO_CULL).m_110691_(false);
        return RenderType.m_173215_((String)"colored_beam", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)translucent, (RenderType.CompositeState)state);
    }

    private static void renderPart(PoseStack matrixStack, VertexConsumer consumer, float gTop, float gBottom, float a, float x0, float z0, float x1, float z1, float x2, float z2, float x3, float z3, float uMin, float uMax, float vTop, float vBottom, float yTop, float yBottom) {
        Matrix4f pose = matrixStack.m_85850_().m_252922_();
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        ColoredBeam.renderQuad(pose, normal, consumer, gTop, gBottom, a, x0, z0, x1, z1, uMax, uMin, vTop, vBottom, yTop, yBottom);
        ColoredBeam.renderQuad(pose, normal, consumer, gTop, gBottom, a, x3, z3, x2, z2, uMax, uMin, vTop, vBottom, yTop, yBottom);
        ColoredBeam.renderQuad(pose, normal, consumer, gTop, gBottom, a, x0, z0, x3, z3, uMax, uMin, vTop, vBottom, yTop, yBottom);
        ColoredBeam.renderQuad(pose, normal, consumer, gTop, gBottom, a, x1, z1, x2, z2, uMax, uMin, vTop, vBottom, yTop, yBottom);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, float gTop, float gBottom, float a, float x0, float z0, float x1, float z1, float u0, float u1, float vTop, float vBottom, float yTop, float yBottom) {
        ColoredBeam.addVertex(pose, normal, consumer, gTop, a, yTop, x0, z0, u0, vTop);
        ColoredBeam.addVertex(pose, normal, consumer, gBottom, a, yBottom, x0, z0, u0, vBottom);
        ColoredBeam.addVertex(pose, normal, consumer, gBottom, a, yBottom, x1, z1, u1, vBottom);
        ColoredBeam.addVertex(pose, normal, consumer, gTop, a, yTop, x1, z1, u1, vTop);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, float g, float a, float y, float x, float z, float u, float v) {
        consumer.m_252986_(pose, x, y, z).m_85950_(1.0f, g, 0.0f, a).m_7421_(u, v).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

