/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import java.util.Random;
import mctmods.immersivetechnology.common.blocks.helper.ITEnums;
import mctmods.immersivetechnology.common.blocks.metal.BarrelOpenBlock;
import mctmods.immersivetechnology.common.blocks.metal.logic.BarrelCommonBlockEntity;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BarrelOpenBlockEntity
extends BarrelCommonBlockEntity {
    private static final Random RANDOM = new Random();
    private static final int tankSize = 12000;

    public BarrelOpenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.BARREL_OPEN.get(), pos, state, 12000);
    }

    @Override
    public void tickServer() {
        int accepted;
        FluidStack simulatedDrain;
        IFluidHandler output;
        FluidStack fs;
        boolean update = false;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && RANDOM.nextInt(20) == 0 && ((fs = this.tank.getFluid()).isEmpty() || fs.getFluid() == Fluids.f_76193_)) {
            Biome biome = (Biome)this.f_58857_.m_204166_(this.f_58858_).m_203334_();
            float temp = biome.m_47554_();
            if (this.f_58857_.m_46758_(this.f_58858_.m_7494_()) && this.f_58857_.m_45527_(this.f_58858_.m_7494_()) && temp > 0.05f && temp < 2.0f) {
                int amount = this.f_58857_.m_46470_() ? 200 : 100;
                this.tank.fill(new FluidStack((Fluid)Fluids.f_76193_, amount), IFluidHandler.FluidAction.EXECUTE);
                update = true;
            } else if (temp >= 2.0f) {
                this.tank.drain(Math.min(100, this.tank.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
                update = true;
            }
        }
        if (this.tank.getFluidAmount() > 0 && this.sideConfig.get(Direction.DOWN) == ITEnums.IOSideConfig.OUTPUT && (output = (IFluidHandler)((CapabilityReference)this.neighbors.get(Direction.DOWN)).getNullable()) != null && !(simulatedDrain = this.tank.drain(Math.min(1000, this.tank.getFluidAmount()), IFluidHandler.FluidAction.SIMULATE)).isEmpty() && (accepted = output.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            FluidStack drained = this.tank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
            output.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            update = true;
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    protected boolean isFluidValid(@NotNull FluidStack fluid) {
        return !fluid.isEmpty() && fluid.getFluid().getFluidType().getDensity(fluid) >= 0;
    }

    @Override
    protected void postRead(boolean descPacket) {
        if (!descPacket) {
            this.updateState();
        }
    }

    @Override
    protected boolean canConfigureSide(Direction side) {
        return side != Direction.UP;
    }

    @Override
    protected void updateState() {
        BlockState newState;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState current = this.m_58900_();
        if (!current.equals(newState = (BlockState)current.m_61124_(BarrelOpenBlock.BOTTOM_CONFIG, (Comparable)((Object)this.sideConfig.getOrDefault(Direction.DOWN, ITEnums.IOSideConfig.OUTPUT))))) {
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        }
    }
}

