/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import mctmods.immersivetechnology.common.blocks.helper.ITEnums;
import mctmods.immersivetechnology.common.blocks.metal.BarrelSteelBlock;
import mctmods.immersivetechnology.common.blocks.metal.logic.BarrelCommonBlockEntity;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BarrelSteelBlockEntity
extends BarrelCommonBlockEntity {
    private static final int tankSize = 24000;

    public BarrelSteelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.BARREL_STEEL.get(), pos, state, 24000);
    }

    @Override
    public void tickServer() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.isRSPowered()) {
            return;
        }
        boolean update = false;
        for (Direction side : this.neighbors.keySet()) {
            int accepted;
            FluidStack simulatedDrain;
            IFluidHandler handler;
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig.get(side) != ITEnums.IOSideConfig.OUTPUT || (handler = (IFluidHandler)((CapabilityReference)this.neighbors.get(side)).getNullable()) == null || (simulatedDrain = this.tank.drain(Math.min(1000, this.tank.getFluidAmount()), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (accepted = handler.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack drained = this.tank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
            handler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            update = true;
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    protected boolean isFluidValid(@NotNull FluidStack fluid) {
        return !fluid.isEmpty();
    }

    @Override
    protected void postRead(boolean descPacket) {
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        } else {
            this.updateState();
        }
    }

    @Override
    protected boolean canConfigureSide(Direction side) {
        return true;
    }

    @Override
    protected void updateState() {
        BlockState newState;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState current = this.m_58900_();
        if (!current.equals(newState = (BlockState)((BlockState)current.m_61124_(BarrelSteelBlock.TOP_CONFIG, (Comparable)((Object)this.sideConfig.getOrDefault(Direction.UP, ITEnums.IOSideConfig.INPUT)))).m_61124_(BarrelSteelBlock.BOTTOM_CONFIG, (Comparable)((Object)this.sideConfig.getOrDefault(Direction.DOWN, ITEnums.IOSideConfig.OUTPUT))))) {
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        }
    }
}

