/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.core.registration.ITRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class GasTurbineRecipe
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<GasTurbineRecipe>> SERIALIZER;
    public static final CachedRecipeList<GasTurbineRecipe> RECIPES;
    public final FluidTagInput input;
    @Nullable
    public final FluidStack fluidOutput;
    private final int time;
    Lazy<Integer> totalProcessTime;

    public GasTurbineRecipe(ResourceLocation id, FluidTagInput input, @Nullable FluidStack fluidOutput, int time) {
        super(LAZY_EMPTY, ITRecipeTypes.GAS_TURBINE, id);
        this.input = input;
        this.fluidOutput = fluidOutput;
        this.time = time;
        this.totalProcessTime = Lazy.of(() -> this.time);
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean matches(FluidStack fluid) {
        return this.input.test(fluid);
    }

    public static GasTurbineRecipe findRecipe(Level level, FluidStack fluid, @Nullable GasTurbineRecipe hint) {
        if (hint != null && hint.matches(fluid)) {
            return hint;
        }
        for (GasTurbineRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.matches(fluid)) continue;
            return recipe;
        }
        return null;
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    static {
        RECIPES = new CachedRecipeList(ITRecipeTypes.GAS_TURBINE);
    }
}

