/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.core;

import com.electronwill.nightconfig.core.Config;
import com.google.common.base.Preconditions;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="immersivetechnology", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ITServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.EnumValue<DisassemblyMode> DISASSEMBLY_MODE;
    public static final ForgeConfigSpec SPEC;
    private static Config rawConfig;

    public static Config getRawConfig() {
        return (Config)Preconditions.checkNotNull((Object)rawConfig);
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfigEvent event) {
        if (event.getConfig().getModId().equals("immersivetechnology")) {
            rawConfig = event.getConfig().getConfigData();
        }
    }

    static {
        BUILDER.push("multiblocks");
        DISASSEMBLY_MODE = BUILDER.comment("Mode for multiblock disassembly. PROCESS_QUEUE: Use gradual queue with fake player. TEMPLATE_BLOCKS: Revert to template blocks like IE.").defineEnum("disassemblyMode", (Enum)DisassemblyMode.PROCESS_QUEUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static enum DisassemblyMode {
        PROCESS_QUEUE,
        TEMPLATE_BLOCKS;

    }
}

