/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui.helper;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.client.gui.helper.IITTooltipWidget;
import mctmods.immersivetechnology.client.gui.helper.ITInfoArea;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class ITContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C> {
    private final ResettableLazy<List<ITInfoArea>> infoAreas;
    protected final ResourceLocation background;

    public ITContainerScreen(C inventorySlotsIn, Inventory inv, Component title, ResourceLocation background) {
        super(inventorySlotsIn, inv, title);
        this.background = background;
        this.infoAreas = new ResettableLazy(this::makeInfoAreas);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.infoAreas.reset();
        this.f_97731_ = this.f_97727_ - 91;
    }

    @Nonnull
    protected List<ITInfoArea> makeInfoAreas() {
        return ImmutableList.of();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, -557004, true);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, -557004, true);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (ITInfoArea area : (List)this.infoAreas.get()) {
            area.fillTooltip(mouseX, mouseY, tooltip);
        }
        for (GuiEventListener w : this.m_6702_()) {
            if (!w.m_5953_((double)mouseX, (double)mouseY) || !(w instanceof IITTooltipWidget)) continue;
            IITTooltipWidget ttw = (IITTooltipWidget)w;
            ttw.gatherTooltip(mouseX, mouseY, tooltip);
        }
        Objects.requireNonNull(tooltip);
        this.gatherAdditionalTooltips(mouseX, mouseY, tooltip::add, t -> tooltip.add((Component)TextUtils.applyFormat((Component)t, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY})));
        if (!tooltip.isEmpty()) {
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            this.m_280072_(graphics, mouseX, mouseY);
        }
    }

    protected final void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawBackgroundTexture(graphics);
        this.drawContainerBackgroundPre(graphics, partialTicks, x, y);
        for (ITInfoArea area : (List)this.infoAreas.get()) {
            area.draw(graphics);
        }
    }

    protected void drawBackgroundTexture(GuiGraphics graphics) {
        graphics.m_280218_(this.background, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
    }

    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
    }

    public int getLeftPos() {
        return this.f_97735_;
    }

    public int getTopPos() {
        return this.f_97736_;
    }
}

