/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlockEntity;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITClientTickableBE;
import mctmods.immersivetechnology.common.blocks.helper.ITEnums;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.common.blocks.metal.BarrelSteelBlock;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelSteelBlockEntity
extends ITBaseBlockEntity
implements ITServerTickableBE,
ITClientTickableBE,
ITBlockInterfaces.IBlockOverlayText,
ITBlockInterfaces.IPlayerInteraction,
ITBlockInterfaces.IBlockEntityDrop,
ITBlockInterfaces.IComparatorOverride,
ITBlockInterfaces.IPlacementInteraction,
ITBlockInterfaces.IConfigurableSides {
    private static final int tankSize = 24000;
    private static final int transferSpeed = 1000;
    public final ITMarkableFluidTank tank = new ITMarkableFluidTank(24000, v -> this.m_6596_());
    public EnumMap<Direction, ITEnums.IOSideConfig> sideConfig = new EnumMap(ImmutableMap.of((Object)Direction.DOWN, (Object)((Object)ITEnums.IOSideConfig.OUTPUT), (Object)Direction.UP, (Object)((Object)ITEnums.IOSideConfig.INPUT)));
    private final Map<Direction, CapabilityReference<IFluidHandler>> neighbors = ImmutableMap.of((Object)Direction.DOWN, (Object)CapabilityReference.forNeighbor((BlockEntity)this, (Capability)ForgeCapabilities.FLUID_HANDLER, (Direction)Direction.DOWN), (Object)Direction.UP, (Object)CapabilityReference.forNeighbor((BlockEntity)this, (Capability)ForgeCapabilities.FLUID_HANDLER, (Direction)Direction.UP));
    private final LazyOptional<IFluidHandler> nonsidedHandler = LazyOptional.of(() -> new SidedFluidHandler(this, null));
    private final LazyOptional<IFluidHandler> upHandler = LazyOptional.of(() -> new SidedFluidHandler(this, Direction.UP));
    private final LazyOptional<IFluidHandler> downHandler = LazyOptional.of(() -> new SidedFluidHandler(this, Direction.DOWN));

    public BarrelSteelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.BARREL_STEEL.get(), pos, state);
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        if (this.isRSPowered()) {
            return;
        }
        boolean update = false;
        for (Direction side : this.neighbors.keySet()) {
            int accepted;
            int out;
            FluidStack simulatedDrain;
            IFluidHandler handler;
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig.get(side) != ITEnums.IOSideConfig.OUTPUT || (handler = (IFluidHandler)this.neighbors.get(side).getNullable()) == null || (simulatedDrain = this.tank.drain(out = Math.min(1000, this.tank.getFluidAmount()), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (accepted = handler.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack drained = this.tank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
            handler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            update = true;
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void readCustomNBT(@NotNull CompoundTag nbt, boolean descPacket) {
        this.sideConfig.clear();
        int[] sideCfgArray = nbt.m_128465_("sideConfig");
        if (sideCfgArray.length >= 2) {
            this.sideConfig.put(Direction.DOWN, ITEnums.IOSideConfig.VALUES[sideCfgArray[0]]);
            this.sideConfig.put(Direction.UP, ITEnums.IOSideConfig.VALUES[sideCfgArray[1]]);
        } else {
            this.sideConfig.put(Direction.DOWN, ITEnums.IOSideConfig.OUTPUT);
            this.sideConfig.put(Direction.UP, ITEnums.IOSideConfig.INPUT);
        }
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        } else {
            this.updateState();
        }
    }

    @Override
    public void writeCustomNBT(@NotNull CompoundTag nbt, boolean descPacket) {
        int[] sideCfgArray = new int[]{this.sideConfig.getOrDefault(Direction.DOWN, ITEnums.IOSideConfig.OUTPUT).ordinal(), this.sideConfig.getOrDefault(Direction.UP, ITEnums.IOSideConfig.INPUT).ordinal()};
        nbt.m_128385_("sideConfig", sideCfgArray);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public boolean isFluidValid(@NotNull FluidStack fluid) {
        return !fluid.isEmpty();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (facing == null) {
                return this.nonsidedHandler.cast();
            }
            if (facing.m_122434_() != Direction.Axis.Y) {
                return super.getCapability(capability, facing);
            }
            return (facing == Direction.UP ? this.upHandler : this.downHandler).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.nonsidedHandler.invalidate();
        this.upHandler.invalidate();
        this.downHandler.invalidate();
    }

    @Override
    public Component[] getOverlayText(@NotNull Player player, @NotNull HitResult rtr, boolean hammer) {
        if (rtr.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            FluidStack fs = this.tank.getFluid();
            if (fs.isEmpty()) {
                return new Component[]{Component.m_237115_((String)TranslationKey.GUI_EMPTY.text())};
            }
            return new Component[]{Component.m_237113_((String)TranslationKey.OVERLAY_OSD_BARREL_NORMAL_FIRST_LINE.format(fs.getDisplayName().getString(), fs.getAmount()))};
        }
        return new Component[0];
    }

    @Override
    public int getComparatorInputOverride() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    @Override
    @NotNull
    public ITEnums.IOSideConfig getSideConfig(@NotNull Direction side) {
        return this.sideConfig.getOrDefault(side, ITEnums.IOSideConfig.NONE);
    }

    @Override
    public boolean toggleSide(Direction side, @NotNull Player p) {
        if (side.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        ITEnums.IOSideConfig next = ITEnums.IOSideConfig.next(this.sideConfig.getOrDefault(side, ITEnums.IOSideConfig.NONE));
        this.sideConfig.put(side, next);
        this.m_6596_();
        this.updateState();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    private void updateState() {
        BlockState newState;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState current = this.m_58900_();
        if (!current.equals(newState = (BlockState)((BlockState)current.m_61124_(BarrelSteelBlock.TOP_CONFIG, (Comparable)((Object)this.sideConfig.getOrDefault(Direction.UP, ITEnums.IOSideConfig.INPUT)))).m_61124_(BarrelSteelBlock.BOTTOM_CONFIG, (Comparable)((Object)this.sideConfig.getOrDefault(Direction.DOWN, ITEnums.IOSideConfig.OUTPUT))))) {
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        }
    }

    @Override
    public boolean interact(@NotNull Direction side, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public void getBlockEntityDrop(@NotNull LootContext context, @NotNull Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag tag = new CompoundTag();
        this.writeTank(tag, true);
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        if (ctx.m_43722_().m_41782_()) {
            this.readTank(ctx.m_43722_().m_41784_());
        }
    }

    public void writeTank(CompoundTag nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
        if (!toItem || write) {
            nbt.m_128365_("tank", (Tag)tankTag);
        }
    }

    public void readTank(CompoundTag nbt) {
        this.tank.readFromNBT(nbt.m_128469_("tank"));
    }

    public static class SidedFluidHandler
    implements IFluidHandler {
        BarrelSteelBlockEntity barrel;
        @Nullable
        Direction facing;

        public SidedFluidHandler(BarrelSteelBlockEntity barrel, @Nullable Direction facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int getTanks() {
            return this.barrel.tank.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.barrel.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.barrel.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.barrel.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || this.facing != null && this.barrel.sideConfig.get(this.facing) != ITEnums.IOSideConfig.INPUT) {
                return 0;
            }
            return this.barrel.tank.fill(resource, action);
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || this.facing != null && this.barrel.sideConfig.get(this.facing) != ITEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            return this.barrel.tank.drain(resource, action);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.facing != null && this.barrel.sideConfig.get(this.facing) != ITEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            return this.barrel.tank.drain(maxDrain, action);
        }
    }
}

