/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.common.blocks.metal.ValveLoadBlock;
import mctmods.immersivetechnology.common.blocks.metal.gui.ValveLoadMenu;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValveLoadBlockEntity
extends ValveCommonBlockEntity
implements ITServerTickableBE,
IImmersiveConnectable,
EnergyTransferHandler.EnergyConnector,
ITBlockInterfaces.IMirrorAble {
    protected static final int RIGHT_INDEX = 0;
    protected static final int LEFT_INDEX = 1;
    protected WireType leftType;
    protected WireType rightType;
    private int bufferedEnergy = 0;
    public int rotation = 0;
    private boolean isUnloading = false;

    public ValveLoadBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.VALVE_LOAD.get(), pos, state, TranslationKey.OVERLAY_OSD_VALVE_LOAD_NORMAL_FIRST_LINE, TranslationKey.OVERLAY_OSD_VALVE_LOAD_SNEAKING_FIRST_LINE, TranslationKey.OVERLAY_OSD_VALVE_LOAD_SNEAKING_SECOND_LINE, 1);
    }

    @Override
    @Nonnull
    public BlockState getState() {
        return this.m_58900_();
    }

    @Override
    public void setState(@Nonnull BlockState state) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.f_58858_, state, 3);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        assert (this.f_58857_ != null);
        this.facing = (Direction)this.m_58900_().m_61143_((Property)ITProperties.FACING_ALL);
        this.rotation = (Integer)this.m_58900_().m_61143_((Property)ValveLoadBlock.ROTATION);
        if (!this.f_58857_.f_46443_) {
            GlobalWireNetwork.getNetwork((Level)this.f_58857_).onConnectorLoad((IImmersiveConnectable)this, this.f_58857_);
            this.efficientSetChanged();
            for (Direction d : Direction.values()) {
                this.f_58857_.m_46586_(this.f_58858_.m_121945_(d), this.m_58900_().m_60734_(), this.f_58858_);
            }
            this.markContainingBlockForUpdate(null);
            this.updateRedstoneState();
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.isUnloading) {
            GlobalWireNetwork global = GlobalWireNetwork.getNetwork((Level)this.f_58857_);
            for (ConnectionPoint cp : this.getConnectionPoints()) {
                LocalWireNetwork net = global.getNullableLocalNet(cp);
                if (net == null) continue;
                for (Connection conn : new ArrayList(net.getConnections(cp))) {
                    ConnectionPoint otherEnd = conn.getOtherEnd(cp);
                    if (net.getConnector(otherEnd) == null) continue;
                    if (this.f_58857_.m_46749_(otherEnd.position())) {
                        global.removeAndDropConnection(conn, this.f_58858_, this.f_58857_);
                        continue;
                    }
                    global.removeConnection(conn);
                }
            }
            global.removeConnector((IImmersiveConnectable)this);
        }
    }

    @Override
    public void onChunkUnloaded() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            GlobalWireNetwork.getNetwork((Level)this.f_58857_).onConnectorUnload((IImmersiveConnectable)this);
            this.isUnloading = true;
        }
        super.onChunkUnloaded();
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        this.updateRedstoneState();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        assert (this.f_58857_ != null);
        long time = this.f_58857_.m_46467_();
        if (time % 12L == (long)((this.f_58858_.m_123341_() ^ this.f_58858_.m_123343_()) & 0xB)) {
            this.updateRedstoneState();
        }
    }

    @NotNull
    protected LocalWireNetwork getLocalNet(int cpIndex) {
        assert (this.f_58857_ != null);
        return GlobalWireNetwork.getNetwork((Level)this.f_58857_).getLocalNet(new ConnectionPoint(this.f_58858_, cpIndex));
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (!offset.equals((Object)Vec3i.f_123288_)) {
            return false;
        }
        WireType atConn = target.index() == 1 ? this.leftType : this.rightType;
        return this.canAttach(cableType, atConn);
    }

    protected boolean canAttach(WireType toAttach, @Nullable WireType atConn) {
        return atConn == null || toAttach.equals(atConn);
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        if (target.index() == 1) {
            this.leftType = cableType;
        } else {
            this.rightType = cableType;
        }
        this.updateMirrorState();
        this.markContainingBlockForUpdate(null);
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        if (type == null) {
            this.rightType = null;
            this.leftType = null;
        } else if (attachedPoint.index() == 1) {
            this.leftType = null;
        } else {
            this.rightType = null;
        }
        this.updateMirrorState();
        this.markContainingBlockForUpdate(null);
    }

    protected void updateMirrorState() {
        int rightL;
        int leftL;
        if (this.leftType != null && this.rightType != null && (leftL = this.getLevel(this.leftType.getCategory())) != (rightL = this.getLevel(this.rightType.getCategory()))) {
            this.setMirrored(rightL > leftL);
        }
    }

    private int getLevel(String cat) {
        if ("LV".equals(cat)) {
            return 1;
        }
        if ("MV".equals(cat)) {
            return 2;
        }
        if ("HV".equals(cat)) {
            return 3;
        }
        return 0;
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        return this.getConnectionOffset(type, here.index() == 0);
    }

    protected Vec3 getConnectionOffset(WireType type, boolean right) {
        double perpOff;
        double conRadius = type.getRenderDiameter() / 2.0;
        Direction facing = this.getFacing();
        boolean isVertical = facing.m_122434_().m_122478_();
        Direction hFacing = isVertical ? Direction.m_122407_((int)this.rotation) : facing;
        boolean mirrored = this.getIsMirrored();
        if (mirrored) {
            right = !right;
        }
        Direction perpDir = isVertical ? hFacing : facing.m_122427_();
        boolean perpPositive = perpDir.m_122421_() == Direction.AxisDirection.POSITIVE;
        double high = 0.8125;
        double low = 0.1875;
        double d = perpOff = right ? low : high;
        if (perpPositive) {
            perpOff = 1.0 - perpOff;
        }
        Direction.Axis perpAxis = perpDir.m_122434_();
        boolean alongPositive = facing.m_122421_() == Direction.AxisDirection.POSITIVE;
        double alongOff = alongPositive ? 1.0 - conRadius : conRadius;
        double xOff = 0.5;
        double yOff = 0.5;
        double zOff = 0.5;
        Direction.Axis alongAxis = facing.m_122434_();
        switch (alongAxis) {
            case X: {
                xOff = alongOff;
                break;
            }
            case Y: {
                yOff = alongOff;
                break;
            }
            case Z: {
                zOff = alongOff;
            }
        }
        switch (perpAxis) {
            case X: {
                xOff = perpOff;
                break;
            }
            case Y: {
                yOff = perpOff;
                break;
            }
            case Z: {
                zOff = perpOff;
            }
        }
        if (!isVertical) {
            yOff = 0.5;
        }
        return new Vec3(xOff, yOff, zOff);
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.f_58858_, 1), (Object)new ConnectionPoint(this.f_58858_, 0));
    }

    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of();
    }

    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo target, Vec3i offset) {
        if (!offset.equals((Object)Vec3i.f_123288_)) {
            return null;
        }
        ConnectionPoint leftCP = new ConnectionPoint(this.f_58858_, 1);
        ConnectionPoint rightCP = new ConnectionPoint(this.f_58858_, 0);
        boolean leftEmpty = this.getLocalNet(1).getConnections(leftCP).stream().allMatch(Connection::isInternal);
        boolean rightEmpty = this.getLocalNet(0).getConnections(rightCP).stream().allMatch(Connection::isInternal);
        if (leftEmpty && !rightEmpty) {
            return leftCP;
        }
        if (!leftEmpty && rightEmpty) {
            return rightCP;
        }
        Direction facing = this.getFacing();
        boolean isVertical = facing.m_122434_().m_122478_();
        Direction hFacing = isVertical ? Direction.m_122407_((int)this.rotation) : facing;
        Direction perpDir = isVertical ? hFacing : facing.m_122427_();
        double hitPos = this.getHitPos(target, perpDir);
        if (hitPos < 0.5) {
            return leftCP;
        }
        return rightCP;
    }

    private double getHitPos(TargetingInfo target, Direction perpDir) {
        boolean positive;
        Direction.Axis perpAxis = perpDir.m_122434_();
        double hitPos = perpAxis == Direction.Axis.X ? (double)target.hitX : (perpAxis == Direction.Axis.Y ? (double)target.hitY : (double)target.hitZ);
        boolean bl = positive = perpDir.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (!positive) {
            hitPos = 1.0 - hitPos;
        }
        return hitPos;
    }

    public BlockPos getConnectionMaster(@Nullable WireType cableType, TargetingInfo target) {
        return this.f_58858_;
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)EnergyTransferHandler.ID);
    }

    @Override
    public void readCustomNBT(@NotNull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.leftType = nbt.m_128441_("leftType") ? WireType.getValue((String)nbt.m_128461_("leftType")) : null;
        this.rightType = nbt.m_128441_("rightType") ? WireType.getValue((String)nbt.m_128461_("rightType")) : null;
        this.rotation = nbt.m_128451_("rotation");
        this.bufferedEnergy = nbt.m_128451_("bufferedEnergy");
        this.updateMirrorState();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.leftType != null) {
            nbt.m_128359_("leftType", this.leftType.getUniqueName());
        }
        if (this.rightType != null) {
            nbt.m_128359_("rightType", this.rightType.getUniqueName());
        }
        nbt.m_128405_("rotation", this.rotation);
        nbt.m_128405_("bufferedEnergy", this.bufferedEnergy);
    }

    @Override
    public void setMirrored(boolean mirrored) {
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)ITProperties.MIRRORED) != mirrored) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ITProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored)), 3);
        }
    }

    @Override
    public boolean getIsMirrored() {
        return (Boolean)this.m_58900_().m_61143_((Property)ITProperties.MIRRORED);
    }

    @Override
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return ValveLoadMenu.makeServer(ITMenuTypes.VALVE_LOAD.getType(), id, inv, this);
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)TranslationKey.GUI_VALVE_LOAD.location);
    }

    @Override
    public boolean stillValid(Player player) {
        return !this.m_58901_() && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public boolean hammerUseSide(@NotNull Direction side, @NotNull Player player, @NotNull InteractionHand hand, @NotNull Vec3 hit) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return false;
        }
        if (this.leftType != null || this.rightType != null) {
            return false;
        }
        boolean counter = player.m_6144_() != (side == Direction.DOWN);
        Direction oldFacing = this.facing;
        Direction newFacing = counter ? oldFacing.m_175364_(side.m_122434_()) : oldFacing.m_175362_(side.m_122434_());
        this.setFacing(newFacing);
        return true;
    }

    public boolean isSource(ConnectionPoint cp) {
        boolean mirrored = this.getIsMirrored();
        int outputIndex = mirrored ? 0 : 1;
        return cp.index() == outputIndex;
    }

    public boolean isSink(ConnectionPoint cp) {
        boolean mirrored = this.getIsMirrored();
        int inputIndex = mirrored ? 1 : 0;
        return cp.index() == inputIndex;
    }

    public int getAvailableEnergy() {
        return (Boolean)this.m_58900_().m_61143_((Property)ValveLoadBlock.OPEN) != false ? this.bufferedEnergy : 0;
    }

    public void extractEnergy(int amount) {
        this.bufferedEnergy -= amount;
        if (this.bufferedEnergy < 0) {
            this.bufferedEnergy = 0;
        }
        this.efficientSetChanged();
    }

    public int getRequestedEnergy() {
        if (!((Boolean)this.m_58900_().m_61143_((Property)ValveLoadBlock.OPEN)).booleanValue()) {
            return 0;
        }
        int canAccept = Integer.MAX_VALUE;
        canAccept = this.timeLimit > 0 ? Math.min(Math.max(this.timeLimit - ValveLoadBlockEntity.longToInt(this.acceptedAmount), 0), canAccept) : canAccept;
        canAccept = this.keepSize > 0 ? Math.min(Math.max(this.keepSize - this.bufferedEnergy, 0), canAccept) : canAccept;
        int n = canAccept = this.packetLimit > 0 ? Math.min(canAccept, this.packetLimit) : canAccept;
        if (this.redstoneMode > 0) {
            canAccept = (int)((double)canAccept * ((double)(this.redstoneMode == 1 ? 15 - this.getRSPower() : this.getRSPower()) / 15.0));
        }
        return canAccept;
    }

    public void insertEnergy(int amount) {
        int max = this.timeLimit > 0 ? Math.max(this.timeLimit - ValveLoadBlockEntity.longToInt(this.acceptedAmount), 0) : amount;
        amount = Math.min(amount, max);
        this.bufferedEnergy += amount;
        this.acceptedAmount += (long)amount;
        ++this.packets;
        this.efficientSetChanged();
    }

    public void onEnergyPassedThrough(double amount) {
    }
}

