/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei.category;

import java.util.List;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITRecipeCategory;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerTankRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ITBoilerTankCategory
extends ITRecipeCategory<BoilerTankRecipe> {
    private final IDrawableStatic tankOverlay;

    public ITBoilerTankCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.BOILER_TANK, "block.immersivetechnology.boiler_tank");
        ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"textures/gui/boiler_tank.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 176, 74).setTextureSize(256, 256).build();
        this.setBackground(back);
        this.setIcon(ITMultiblockProvider.BOILER_TANK.iconStack());
        this.tankOverlay = helper.createDrawable(background, 177, 31, 20, 51);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BoilerTankRecipe recipe, @NotNull IFocusGroup focuses) {
        List<FluidStack> inputs = recipe.input.getMatchingFluidStacks().stream().map(fs -> {
            FluidStack copy = fs.copy();
            copy.setAmount(recipe.input.getAmount());
            return copy;
        }).toList();
        IRecipeSlotBuilder inputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 67, 21).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs)).setFluidRenderer((long)recipe.input.getAmount(), false, 16, 47);
        inputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.input.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 21).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.output)).setFluidRenderer((long)recipe.output.getAmount(), false, 16, 47);
        outputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, fs.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
    }

    public void draw(@NotNull BoilerTankRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.tankOverlay.draw(guiGraphics, 65, 19);
        this.tankOverlay.draw(guiGraphics, 90, 19);
    }
}

