/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ITSlotwiseItemHandler
implements IItemHandlerModifiable,
Iterable<ItemStack> {
    private final ItemStackHandler rawHandler;
    private final List<IOConstraint> slotConstraints;

    public ITSlotwiseItemHandler(List<IOConstraint> slotConstraints, final Runnable onChanged) {
        this.rawHandler = new ItemStackHandler(slotConstraints.size()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                onChanged.run();
            }
        };
        this.slotConstraints = slotConstraints;
    }

    public int getSlots() {
        return this.rawHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.rawHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack after;
        if (slot >= this.slotConstraints.size()) {
            return stack;
        }
        boolean allowInsert = this.slotConstraints.get((int)slot).allowInsert.test(stack);
        if (!allowInsert) {
            return stack;
        }
        ItemStack current = this.getStackInSlot(slot);
        if (!current.m_41619_() && !ItemStack.m_150942_((ItemStack)current, (ItemStack)stack)) {
            return stack;
        }
        ItemStack result = this.rawHandler.insertItem(slot, stack, simulate);
        if (!simulate && (after = this.getStackInSlot(slot)).m_41613_() > this.getSlotLimit(slot)) {
            after.m_41764_(this.getSlotLimit(slot));
            this.rawHandler.setStackInSlot(slot, after);
        }
        return result;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.slotConstraints.size() || !this.slotConstraints.get(slot).allowExtract()) {
            return ItemStack.f_41583_;
        }
        return this.rawHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.rawHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot >= this.slotConstraints.size()) {
            return false;
        }
        return this.slotConstraints.get((int)slot).allowInsert.test(stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        ItemStack toSet = stack.m_41777_();
        toSet.m_41764_(Math.min(toSet.m_41613_(), this.getSlotLimit(slot)));
        this.rawHandler.setStackInSlot(slot, toSet);
    }

    public Tag serializeNBT() {
        return this.rawHandler.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.rawHandler.deserializeNBT(nbt);
    }

    public ItemStackHandler getRawHandler() {
        return this.rawHandler;
    }

    @Override
    @Nonnull
    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            private int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < ITSlotwiseItemHandler.this.getSlots();
            }

            @Override
            public ItemStack next() {
                ItemStack next = ITSlotwiseItemHandler.this.getStackInSlot(this.slot);
                ++this.slot;
                return next;
            }
        };
    }

    public record IOConstraint(boolean allowExtract, Predicate<ItemStack> allowInsert) {
        public static final IOConstraint INPUT = IOConstraint.input($ -> true);
        public static final IOConstraint OUTPUT = new IOConstraint(true, $ -> false);
        public static final IOConstraint FLUID_INPUT = IOConstraint.input(Utils::isFluidRelatedItemStack);

        public static IOConstraint input(Predicate<ItemStack> allow) {
            return new IOConstraint(true, allow);
        }
    }
}

