/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SteelSheetmetalTankShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class SteelSheetmetalTankLogic
implements IServerTickableComponent<State>,
MBOverlayText<State>,
ITPressurizedFluidOutput<State> {
    private static final int CAPACITY = 2048000;
    private static final int TRANSFER_SPEED = 1000;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])SteelSheetmetalTankShape.DATA.pointsOfInterest);
    public static final BlockPos REDSTONE_POI = SteelSheetmetalTankLogic.getPosList().get(0);
    private static final List<CapabilityPosition> INPUT_POIS = SteelSheetmetalTankLogic.getCapabilityPositions("fluid_input");
    private static final List<CapabilityPosition> IO_POIS = SteelSheetmetalTankLogic.getCapabilityPositions("fluid_io");
    private static final BlockPos COMPARATOR_BASE = SteelSheetmetalTankLogic.getPosList("comparator_base").get(0);
    private static final List<BlockPos> COMPARATOR_LAYERS = (List)RAW_POIS.stream().filter(poi -> poi.name.equals("comparator_layer")).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).sorted(Comparator.comparingInt(Vec3i::m_123342_)).collect(ImmutableList.toImmutableList());

    private static List<BlockPos> getPosList() {
        return SteelSheetmetalTankLogic.getPosList("redstone");
    }

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static List<CapabilityPosition> getCapabilityPositions(String name) {
        ArrayList<CapabilityPosition> result = new ArrayList<CapabilityPosition>();
        for (PoIJSONSchema poi : RAW_POIS) {
            if (!poi.name.equals(name)) continue;
            BlockPos connPos = new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2]);
            for (RelativeBlockFace face : poi.relativeFaces) {
                result.add(new CapabilityPosition(connPos, face));
            }
        }
        if (result.isEmpty()) {
            throw new RuntimeException("No POI found for " + name);
        }
        return ImmutableList.copyOf(result);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return (List)IO_POIS.stream().map(CapabilityPosition::posInMultiblock).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return null;
    }

    @Override
    public List<RelativeBlockFace> getOutputFacings() {
        return (List)IO_POIS.stream().map(CapabilityPosition::side).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return (List)Stream.generate(() -> state.tank).limit(IO_POIS.size()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return state.outputs;
    }

    @Override
    public int getTransferSpeed() {
        return 1000;
    }

    @Override
    public boolean shouldPumpOutputs(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        return state.rsState.isEnabled(ctx) && !state.tank.isEmpty();
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean isActive;
        State state = (State)ctx.getState();
        state.comparatorHelper.update(ctx, (double)state.tank.getFluidAmount());
        boolean enabled = state.rsState.isEnabled(ctx);
        boolean bl = isActive = enabled && !state.tank.isEmpty();
        if (state.active != isActive) {
            state.active = isActive;
            ctx.markDirtyAndSync();
        }
        this.pumpOutputs(ctx);
    }

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            BlockPos posIn = position.posInMultiblock();
            RelativeBlockFace side = position.side();
            if (side != null) {
                if (INPUT_POIS.stream().anyMatch(p -> p.posInMultiblock().equals((Object)posIn) && p.side() == side)) {
                    return state.inputHandler.cast(ctx);
                }
                if (IO_POIS.stream().anyMatch(p -> p.posInMultiblock().equals((Object)posIn) && p.side() == side)) {
                    return state.ioHandler.cast(ctx);
                }
            }
        }
        return LazyOptional.empty();
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()));
        }
        return null;
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SteelSheetmetalTankShape.GETTER;
    }

    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (posInMultiblock.equals((Object)REDSTONE_POI) && player.m_21120_(hand).m_204117_(IETags.screwdrivers)) {
            if (!isClient) {
                State state = (State)ctx.getState();
                try {
                    Field f = RedstoneControl.RSState.class.getDeclaredField("rsEnablesMachine");
                    f.setAccessible(true);
                    boolean current = (Boolean)f.get(state.rsState);
                    boolean inverted = !current;
                    f.set(state.rsState, inverted);
                    player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl." + (inverted ? "invertedOff" : "invertedOn"))), true);
                    ctx.markDirtyAndSync();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invert RSState", e);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (FluidUtils.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((State)ctx.getState()).tank)) {
            ctx.markDirtyAndSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final ITMarkableFluidTank tank;
        private final LayeredComparatorOutput<IMultiblockContext<State>> comparatorHelper;
        private final List<CapabilityReference<IFluidHandler>> outputs;
        private final StoredCapability<IFluidHandler> inputHandler;
        private final StoredCapability<IFluidHandler> ioHandler;
        public RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();
        public boolean active = false;

        public State(IInitialMultiblockContext<State> capabilitySource) {
            ImmutableList.Builder outputBuilder = ImmutableList.builder();
            for (CapabilityPosition p : IO_POIS) {
                MultiblockFace mbf = new MultiblockFace(p.side(), p.posInMultiblock());
                CapabilityPosition opp = CapabilityPosition.opposing((MultiblockFace)mbf);
                outputBuilder.add((Object)capabilitySource.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, opp.posInMultiblock(), opp.side()));
            }
            this.outputs = outputBuilder.build();
            Runnable changedAndSync = () -> {
                capabilitySource.getSyncRunnable().run();
                capabilitySource.getMarkDirtyRunnable().run();
            };
            this.tank = new ITMarkableFluidTank(2048000, v -> changedAndSync.run());
            this.inputHandler = new StoredCapability((Object)new ConditionalFluidHandler(this.tank, true, false, changedAndSync, () -> false));
            this.ioHandler = new StoredCapability((Object)new ConditionalFluidHandler(this.tank, true, true, changedAndSync, () -> true));
            try {
                Field positionsField = RedstoneControl.RSState.class.getDeclaredField("positions");
                positionsField.setAccessible(true);
                positionsField.set(this.rsState, ImmutableList.of((Object)REDSTONE_POI));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set RSState positions", e);
            }
            this.comparatorHelper = new LayeredComparatorOutput((double)this.tank.getCapacity(), COMPARATOR_LAYERS.size(), (ctx, value) -> {
                BlockPos pos = COMPARATOR_BASE;
                IMultiblockLevel level = ctx.getLevel();
                ctx.setComparatorOutputFor(pos, value);
                BlockPos absPos = level.toAbsolute(pos);
                BlockState stateAt = level.getBlockState(pos);
                level.getRawLevel().m_46672_(absPos, stateAt.m_60734_());
            }, (ctx, layer, value) -> {
                BlockPos pos = COMPARATOR_LAYERS.get(layer);
                IMultiblockLevel level = ctx.getLevel();
                ctx.setComparatorOutputFor(pos, value);
                BlockPos absPos = level.toAbsolute(pos);
                BlockState stateAt = level.getBlockState(pos);
                level.getRawLevel().m_46672_(absPos, stateAt.m_60734_());
            });
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public List<AveragingEnergyStorage> getEnergies() {
            return ImmutableList.of();
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return null;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tank};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            CompoundTag rsTag = new CompoundTag();
            this.rsState.writeSaveNBT(rsTag);
            nbt.m_128365_("rsState", (Tag)rsTag);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.rsState.readSaveNBT(nbt.m_128469_("rsState"));
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
            nbt.m_128379_("active", this.active);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
            this.active = nbt.m_128471_("active");
        }
    }

    private record ConditionalFluidHandler(ITMarkableFluidTank tank, boolean canFill, boolean canDrain, Runnable onChange, Supplier<Boolean> allowDrain) implements IFluidHandler
    {
        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.tank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tank.getCapacity();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.tank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.canFill || resource.isEmpty()) {
                return 0;
            }
            if (action == IFluidHandler.FluidAction.SIMULATE) {
                return this.tank.fill(resource, IFluidHandler.FluidAction.SIMULATE);
            }
            int filled = this.tank.fill(resource, IFluidHandler.FluidAction.EXECUTE);
            if (filled > 0) {
                this.onChange.run();
            }
            return filled;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.canDrain || !this.allowDrain.get().booleanValue() || resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.tank.drain(resource, action);
            if (!drained.isEmpty() && action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange.run();
            }
            return drained;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!this.canDrain || !this.allowDrain.get().booleanValue() || maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.tank.drain(maxDrain, action);
            if (!drained.isEmpty() && action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange.run();
            }
            return drained;
        }
    }
}

