/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.core.registration.ITRecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class SolarMelterRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<SolarMelterRecipe>> SERIALIZER;
    public static final CachedRecipeList<SolarMelterRecipe> RECIPES;
    public final FluidTagInput input;
    public final FluidStack fluidOutput;
    private final int time;
    public final double requiredTemp;

    public SolarMelterRecipe(ResourceLocation id, FluidTagInput input, @Nullable FluidStack fluidOutput, int time, double requiredTemp) {
        super(Lazy.of(() -> ItemStack.f_41583_), ITRecipeTypes.SOLAR_MELTER, id);
        this.input = input;
        this.fluidOutput = fluidOutput;
        this.time = time;
        this.requiredTemp = requiredTemp;
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.input});
        this.fluidOutputList = fluidOutput == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new FluidStack[]{fluidOutput});
    }

    @Nullable
    public static SolarMelterRecipe findRecipe(Level level, FluidStack fluid) {
        if (fluid == null || fluid.isEmpty()) {
            return null;
        }
        for (SolarMelterRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.input.testIgnoringAmount(fluid) || fluid.getAmount() < recipe.input.getAmount()) continue;
            return recipe;
        }
        return null;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public int getTotalProcessTime() {
        return this.time;
    }

    public int getTotalProcessEnergy() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList(ITRecipeTypes.SOLAR_MELTER);
    }
}

