/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe.serializer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarMelterRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarMelterRecipeSerializer
extends IERecipeSerializer<SolarMelterRecipe> {
    public ItemStack getIcon() {
        return ITMultiblockProvider.SOLAR_MELTER.iconStack();
    }

    public SolarMelterRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext iContext) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        FluidStack fluidOutput = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        double requiredTemp = GsonHelper.m_144784_((JsonObject)json, (String)"requiredTemp");
        return new SolarMelterRecipe(recipeId, input, fluidOutput, time, requiredTemp);
    }

    @Nullable
    public SolarMelterRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        FluidStack fluidOutput = buffer.readFluidStack();
        int time = buffer.readInt();
        double requiredTemp = buffer.readDouble();
        return new SolarMelterRecipe(recipeId, input, fluidOutput, time, requiredTemp);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull SolarMelterRecipe recipe) {
        recipe.input.write(buffer);
        buffer.writeFluidStack(recipe.fluidOutput);
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeDouble(recipe.requiredTemp);
    }
}

