/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mctmods.immersivetechnology.client.renderer.helper.ITRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class ITGuiHelper {
    public static void drawRepeatedFluidSpriteGui(MultiBufferSource buffer, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = ITRenderTypes.getGuiTranslucent(InventoryMenu.f_39692_);
        VertexConsumer builder = buffer.m_6299_(renderType);
        ITGuiHelper.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(VertexConsumer builder, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(props.getStillTexture(fluid));
        int col = props.getTintColor(fluid);
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        float a = 1.0f;
        int iW = sprite.m_245424_().m_246492_();
        int iH = sprite.m_245424_().m_245330_();
        if (iW > 0 && iH > 0) {
            ITGuiHelper.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), r, g, b, a);
        }
    }

    public static void drawRepeatedSprite(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ITGuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            ITGuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ITGuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ITGuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawTexturedRect(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, float picSize, float u0, float u1, float v0, float v1) {
        ITGuiHelper.drawTexturedColoredRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, u0 / picSize, u1 / picSize, v0 / picSize, v1 / picSize);
    }

    public static void drawTexturedColoredRect(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        Matrix4f mat = transform.m_85850_().m_252922_();
        int ir = (int)(255.0f * r);
        int ig = (int)(255.0f * g);
        int ib = (int)(255.0f * b);
        int ia = (int)(255.0f * alpha);
        int light = LightTexture.m_109885_((int)15, (int)15);
        boolean nx = false;
        boolean ny = false;
        int nz = 127;
        builder.m_252986_(mat, x, y + h, 0.0f).m_6122_(ir, ig, ib, ia).m_7421_(u0, v1).m_85969_(light).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        builder.m_252986_(mat, x + w, y + h, 0.0f).m_6122_(ir, ig, ib, ia).m_7421_(u1, v1).m_85969_(light).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        builder.m_252986_(mat, x + w, y, 0.0f).m_6122_(ir, ig, ib, ia).m_7421_(u1, v0).m_85969_(light).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
        builder.m_252986_(mat, x, y, 0.0f).m_6122_(ir, ig, ib, ia).m_7421_(u0, v0).m_85969_(light).m_5601_((float)nx, (float)ny, (float)nz).m_5752_();
    }
}

