/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.mirror;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import mctmods.immersivetechnology.client.models.helper.ITICacheKeyProvider;
import mctmods.immersivetechnology.client.models.mirror.ITCachedMirroredModel;
import mctmods.immersivetechnology.client.models.mirror.ITMirroredModelLoader;
import mctmods.immersivetechnology.client.models.mirror.ITMirroredModelState;
import mctmods.immersivetechnology.client.models.util.ITModelUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public record ITMirroredGeometry(UnbakedModel inner) implements IUnbakedGeometry<ITMirroredGeometry>
{
    public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLoc) {
        BakedModel baseResult = this.inner.m_7611_(bakery, spriteGetter, (ModelState)new ITMirroredModelState(modelState), modelLoc);
        if (!(baseResult instanceof SimpleBakedModel)) {
            if (baseResult instanceof ITICacheKeyProvider) {
                ITICacheKeyProvider cachedModel = (ITICacheKeyProvider)baseResult;
                return new ITCachedMirroredModel(cachedModel);
            }
            throw new RuntimeException("Tried to mirror model " + String.valueOf(this.inner) + " which is neither simple nor cacheable");
        }
        SimpleBakedModel simpleModel = (SimpleBakedModel)baseResult;
        List<BakedQuad> unculledQuads = ITMirroredModelLoader.getReversedQuads(simpleModel, null);
        EnumMap<Direction, List<BakedQuad>> culledQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction d : DirectionUtils.VALUES) {
            culledQuads.put(d, ITMirroredModelLoader.getReversedQuads(simpleModel, d));
        }
        return new SimpleBakedModel(unculledQuads, culledQuads, baseResult.m_7541_(), baseResult.m_7547_(), baseResult.m_7539_(), baseResult.getParticleIcon(ModelData.EMPTY), simpleModel.m_7442_(), baseResult.m_7343_(), ITModelUtils.copyTypes(simpleModel), ITModelUtils.copyTypesFast(simpleModel));
    }
}

