/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.split;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.client.models.split.ITUnbakedSplitModel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class ITSplitModelLoader
implements IGeometryLoader<ITUnbakedSplitModel> {
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"basic_split");
    public static final String PARTS = "split_parts";
    public static final String INNER_MODEL = "inner_model";
    public static final String DYNAMIC = "dynamic";

    @Nonnull
    public ITUnbakedSplitModel read(JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
        JsonElement innerJson = modelContents.get(INNER_MODEL);
        UnbakedModel baseModel = (UnbakedModel)ExtendedBlockModelDeserializer.INSTANCE.fromJson(innerJson, BlockModel.class);
        JsonArray partsJson = modelContents.getAsJsonArray(PARTS);
        ArrayList<Vec3i> parts = new ArrayList<Vec3i>(partsJson.size());
        for (JsonElement e : partsJson) {
            parts.add(this.fromJson(e.getAsJsonArray()));
        }
        List positions = parts.stream().map(BlockPos::new).collect(Collectors.toList());
        Optional optBox = BoundingBox.m_162378_(positions);
        BoundingBox box = (BoundingBox)optBox.orElseThrow(() -> new IllegalStateException("No positions to encapsulate"));
        Vec3i size = new Vec3i(box.m_71056_(), box.m_71057_(), box.m_71058_());
        return new ITUnbakedSplitModel(baseModel, parts, modelContents.get(DYNAMIC).getAsBoolean(), size);
    }

    private Vec3i fromJson(JsonArray a) {
        return new Vec3i(a.get(0).getAsInt(), a.get(1).getAsInt(), a.get(2).getAsInt());
    }
}

