/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei.category;

import java.util.List;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITRecipeCategory;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerLiquidRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ITBoilerLiquidCategory
extends ITRecipeCategory<BoilerLiquidRecipe> {
    private final IDrawableStatic tankOverlay;

    public ITBoilerLiquidCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.BOILER_LIQUID, "block.immersivetechnology.boiler_liquid");
        ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"textures/gui/boiler_liquid.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 176, 74).setTextureSize(256, 256).build();
        this.setBackground(back);
        this.setIcon(ITMultiblockProvider.BOILER_LIQUID.iconStack());
        this.tankOverlay = helper.createDrawable(background, 177, 31, 20, 51);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BoilerLiquidRecipe recipe, @NotNull IFocusGroup focuses) {
        List<FluidStack> inputs = recipe.input.getMatchingFluidStacks().stream().map(fs -> {
            FluidStack copy = fs.copy();
            copy.setAmount(recipe.input.getAmount());
            return copy;
        }).toList();
        IRecipeSlotBuilder inputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 80, 21).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs)).setFluidRenderer((long)recipe.input.getAmount(), false, 16, 47);
        inputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.input.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
    }

    public void draw(@NotNull BoilerLiquidRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.tankOverlay.draw(guiGraphics, 78, 19);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent timeComponent = Component.m_237110_((String)"category.immersivetechnology.metal_multiblock.boiler_liquid.time", (Object[])new Object[]{recipe.getTotalProcessTime(), recipe.input.getAmount()}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
        int timeWidth = font.m_92852_((FormattedText)timeComponent);
        int timeX = 88 - timeWidth / 2;
        guiGraphics.m_280614_(font, (Component)timeComponent, timeX, 0, 0xAAAAAA, true);
        MutableComponent heatComponent = Component.m_237110_((String)"category.immersivetechnology.metal_multiblock.boiler_liquid.heat", (Object[])new Object[]{String.format("%.2f", recipe.getHeatPerTick())}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
        int heatWidth = font.m_92852_((FormattedText)heatComponent);
        int heatX = 88 - heatWidth / 2;
        guiGraphics.m_280614_(font, (Component)heatComponent, heatX, 9, 0xAAAAAA, true);
    }
}

