/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei.category;

import java.util.List;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITRecipeCategory;
import mctmods.immersivetechnology.common.multiblocks.stone.recipe.CoolingTowerRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ITCoolingTowerCategory
extends ITRecipeCategory<CoolingTowerRecipe> {
    private final IDrawableStatic tankOverlay;

    public ITCoolingTowerCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.COOLING_TOWER, "block.immersivetechnology.cooling_tower");
        ResourceLocation guiTexture = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"textures/gui/boiler_liquid.png");
        IDrawableStatic back = this.guiHelper.createBlankDrawable(176, 74);
        this.setBackground(back);
        this.setIcon(ITMultiblockProvider.COOLING_TOWER.iconStack());
        this.tankOverlay = helper.createDrawable(guiTexture, 177, 31, 20, 51);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull CoolingTowerRecipe recipe, @NotNull IFocusGroup focuses) {
        List<FluidStack> inputs0 = recipe.input0.getMatchingFluidStacks().stream().map(fs -> {
            FluidStack copy = fs.copy();
            copy.setAmount(recipe.input0.getAmount());
            return copy;
        }).toList();
        IRecipeSlotBuilder input0Slot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 38, 21).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs0)).setFluidRenderer((long)recipe.input0.getAmount(), false, 16, 47);
        input0Slot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.input0.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        List<FluidStack> inputs1 = recipe.input1.getMatchingFluidStacks().stream().map(fs -> {
            FluidStack copy = fs.copy();
            copy.setAmount(recipe.input1.getAmount());
            return copy;
        }).toList();
        IRecipeSlotBuilder input1Slot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 62, 21).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs1)).setFluidRenderer((long)recipe.input1.getAmount(), false, 16, 47);
        input1Slot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.input1.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        if (recipe.fluidOutput0 != null && !recipe.fluidOutput0.isEmpty()) {
            IRecipeSlotBuilder output0Slot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 21).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput0)).setFluidRenderer((long)recipe.fluidOutput0.getAmount(), false, 16, 47);
            output0Slot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.fluidOutput0.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        }
        if (recipe.fluidOutput1 != null && !recipe.fluidOutput1.isEmpty()) {
            IRecipeSlotBuilder output1Slot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 122, 21).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput1)).setFluidRenderer((long)recipe.fluidOutput1.getAmount(), false, 16, 47);
            output1Slot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.fluidOutput1.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        }
        if (recipe.fluidOutput2 != null && !recipe.fluidOutput2.isEmpty()) {
            IRecipeSlotBuilder output2Slot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 146, 21).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput2)).setFluidRenderer((long)recipe.fluidOutput2.getAmount(), false, 16, 47);
            output2Slot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.fluidOutput2.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        }
    }

    public void draw(@NotNull CoolingTowerRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.tankOverlay.draw(guiGraphics, 36, 19);
        this.tankOverlay.draw(guiGraphics, 60, 19);
        if (recipe.fluidOutput0 != null && !recipe.fluidOutput0.isEmpty()) {
            this.tankOverlay.draw(guiGraphics, 96, 19);
        }
        if (recipe.fluidOutput1 != null && !recipe.fluidOutput1.isEmpty()) {
            this.tankOverlay.draw(guiGraphics, 120, 19);
        }
        if (recipe.fluidOutput2 != null && !recipe.fluidOutput2.isEmpty()) {
            this.tankOverlay.draw(guiGraphics, 144, 19);
        }
    }
}

