/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei.category;

import java.util.List;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITRecipeCategory;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarMelterRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ITSolarMelterCategory
extends ITRecipeCategory<SolarMelterRecipe> {
    private final IDrawableStatic tankOverlay;

    public ITSolarMelterCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.SOLAR_MELTER, "block.immersivetechnology.solar_melter");
        ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"textures/gui/solar.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 176, 74).setTextureSize(256, 256).build();
        this.setBackground(back);
        this.setIcon(ITMultiblockProvider.SOLAR_MELTER.iconStack());
        this.tankOverlay = helper.createDrawable(background, 177, 31, 20, 51);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull SolarMelterRecipe recipe, @NotNull IFocusGroup focuses) {
        List<FluidStack> inputs = recipe.input.getMatchingFluidStacks().stream().map(fs -> {
            FluidStack copy = fs.copy();
            copy.setAmount(recipe.input.getAmount());
            return copy;
        }).toList();
        IRecipeSlotBuilder inputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 102, 21).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs)).setFluidRenderer((long)recipe.input.getAmount(), false, 16, 47);
        inputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.input.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        if (recipe.fluidOutput != null) {
            IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 126, 21).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput)).setFluidRenderer((long)recipe.fluidOutput.getAmount(), false, 16, 47);
            outputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, fs.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        }
    }

    public void draw(@NotNull SolarMelterRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.tankOverlay.draw(guiGraphics, 100, 19);
        if (recipe.fluidOutput != null) {
            this.tankOverlay.draw(guiGraphics, 124, 19);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent timeComponent = Component.m_237110_((String)"category.immersivetechnology.metal_multiblock.solar_melter.time", (Object[])new Object[]{recipe.getTotalProcessTime(), recipe.input.getAmount()}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
        int timeWidth = font.m_92852_((FormattedText)timeComponent);
        int timeX = 122 - timeWidth / 2;
        guiGraphics.m_280614_(font, (Component)timeComponent, timeX, 0, 0xAAAAAA, true);
        MutableComponent tempComponent = Component.m_237110_((String)"category.immersivetechnology.metal_multiblock.solar_melter.temp", (Object[])new Object[]{recipe.requiredTemp}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
        int tempWidth = font.m_92852_((FormattedText)tempComponent);
        int tempX = 122 - tempWidth / 2;
        guiGraphics.m_280614_(font, (Component)tempComponent, tempX, 9, 0xAAAAAA, true);
    }
}

